/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TestContextTransactionUtils {
    public static final String DEFAULT_DATA_SOURCE_NAME = "dataSource";
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";
    private static final Log logger = LogFactory.getLog(TestContextTransactionUtils.class);

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSource retrieveDataSource(TestContext testContext, String name) {
        AutowireCapableBeanFactory bf;
        block8: {
            Assert.notNull(testContext, "TestContext must not be null");
            bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                if (StringUtils.hasText(name)) {
                    return bf.getBean(name, DataSource.class);
                }
            }
            catch (BeansException ex) {
                logger.error(String.format("Failed to retrieve DataSource named '%s' for test context %s", name, testContext), ex);
                throw ex;
            }
            if (!(bf instanceof ListableBeanFactory)) return bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
            ListableBeanFactory lbf = (ListableBeanFactory)((Object)bf);
            Map<String, DataSource> dataSources = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, DataSource.class);
            if (dataSources.size() != 1) break block8;
            return dataSources.values().iterator().next();
            {
                catch (BeansException ex) {
                    TestContextTransactionUtils.logBeansException(testContext, ex, DataSource.class);
                    return null;
                }
            }
        }
        try {
            return bf.getBean(DataSource.class);
        }
        catch (BeansException ex) {
            TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
            return bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlatformTransactionManager retrieveTransactionManager(TestContext testContext, String name) {
        ListableBeanFactory lbf;
        AutowireCapableBeanFactory bf;
        block8: {
            Assert.notNull(testContext, "TestContext must not be null");
            bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                if (StringUtils.hasText(name)) {
                    return bf.getBean(name, PlatformTransactionManager.class);
                }
            }
            catch (BeansException ex) {
                logger.error(String.format("Failed to retrieve transaction manager named '%s' for test context %s", name, testContext), ex);
                throw ex;
            }
            if (!(bf instanceof ListableBeanFactory)) return bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
            lbf = (ListableBeanFactory)((Object)bf);
            Map<String, PlatformTransactionManager> txMgrs = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, PlatformTransactionManager.class);
            if (txMgrs.size() != 1) break block8;
            return txMgrs.values().iterator().next();
            {
                catch (BeansException ex) {
                    TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
                    return null;
                }
            }
        }
        try {
            return bf.getBean(PlatformTransactionManager.class);
        }
        catch (BeansException ex) {
            TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
            Map<String, TransactionManagementConfigurer> configurers = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, TransactionManagementConfigurer.class);
            Assert.state(configurers.size() <= 1, "Only one TransactionManagementConfigurer may exist in the ApplicationContext");
            if (configurers.size() != 1) return bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
            return configurers.values().iterator().next().annotationDrivenTransactionManager();
        }
    }

    private static void logBeansException(TestContext testContext, BeansException ex, Class<?> beanType) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Caught exception while retrieving %s for test context %s", beanType.getSimpleName(), testContext), ex);
        }
    }

    public static TransactionAttribute createDelegatingTransactionAttribute(TestContext testContext, TransactionAttribute targetAttribute) {
        Assert.notNull(testContext, "TestContext must not be null");
        Assert.notNull(targetAttribute, "Target TransactionAttribute must not be null");
        return new TestContextTransactionAttribute(targetAttribute, testContext);
    }

    private static class TestContextTransactionAttribute
    extends DelegatingTransactionAttribute {
        private final String name;

        public TestContextTransactionAttribute(TransactionAttribute targetAttribute, TestContext testContext) {
            super(targetAttribute);
            this.name = ClassUtils.getQualifiedMethodName(testContext.getTestMethod(), testContext.getTestClass());
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

