/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.test.context.web.AbstractGenericWebContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class GenericXmlWebContextLoader
extends AbstractGenericWebContextLoader {
    @Override
    protected void loadBeanDefinitions(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        new XmlBeanDefinitionReader(context).loadBeanDefinitions(webMergedConfig.getLocations());
    }

    @Override
    protected String getResourceSuffix() {
        return "-context.xml";
    }

    @Override
    protected void validateMergedContextConfiguration(WebMergedContextConfiguration webMergedConfig) {
        if (webMergedConfig.hasClasses()) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'classes' attribute %s, but %s does not support annotated classes.", webMergedConfig.getTestClass().getName(), ObjectUtils.nullSafeToString(webMergedConfig.getClasses()), this.getClass().getSimpleName());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }
}

