/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptorAdapter;

public class DeferredResult<T> {
    private static final Object RESULT_NONE = new Object();
    private static final Log logger = LogFactory.getLog(DeferredResult.class);
    private final Long timeout;
    private final Object timeoutResult;
    private Runnable timeoutCallback;
    private Runnable completionCallback;
    private DeferredResultHandler resultHandler;
    private volatile Object result = RESULT_NONE;
    private volatile boolean expired = false;

    public DeferredResult() {
        this(null, RESULT_NONE);
    }

    public DeferredResult(Long timeout) {
        this(timeout, RESULT_NONE);
    }

    public DeferredResult(Long timeout, Object timeoutResult) {
        this.timeoutResult = timeoutResult;
        this.timeout = timeout;
    }

    public final boolean isSetOrExpired() {
        return this.result != RESULT_NONE || this.expired;
    }

    public boolean hasResult() {
        return this.result != RESULT_NONE;
    }

    public Object getResult() {
        Object resultToCheck = this.result;
        return resultToCheck != RESULT_NONE ? resultToCheck : null;
    }

    final Long getTimeoutValue() {
        return this.timeout;
    }

    public void onTimeout(Runnable callback) {
        this.timeoutCallback = callback;
    }

    public void onCompletion(Runnable callback) {
        this.completionCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResultHandler(DeferredResultHandler resultHandler) {
        Object resultToHandle;
        Assert.notNull(resultHandler, "DeferredResultHandler is required");
        if (this.expired) {
            return;
        }
        DeferredResult deferredResult = this;
        synchronized (deferredResult) {
            if (this.expired) {
                return;
            }
            resultToHandle = this.result;
            if (resultToHandle == RESULT_NONE) {
                this.resultHandler = resultHandler;
                return;
            }
        }
        try {
            resultHandler.handleResult(resultToHandle);
        }
        catch (Throwable ex) {
            logger.debug("Failed to handle existing result", ex);
        }
    }

    public boolean setResult(T result) {
        return this.setResultInternal(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setResultInternal(Object result) {
        DeferredResultHandler resultHandlerToUse;
        if (this.isSetOrExpired()) {
            return false;
        }
        DeferredResult deferredResult = this;
        synchronized (deferredResult) {
            if (this.isSetOrExpired()) {
                return false;
            }
            this.result = result;
            resultHandlerToUse = this.resultHandler;
            if (resultHandlerToUse == null) {
                return true;
            }
            this.resultHandler = null;
        }
        resultHandlerToUse.handleResult(result);
        return true;
    }

    public boolean setErrorResult(Object result) {
        return this.setResultInternal(result);
    }

    final DeferredResultProcessingInterceptor getInterceptor() {
        return new DeferredResultProcessingInterceptorAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <S> boolean handleTimeout(NativeWebRequest request, DeferredResult<S> deferredResult) {
                boolean continueProcessing = true;
                try {
                    if (DeferredResult.this.timeoutCallback != null) {
                        DeferredResult.this.timeoutCallback.run();
                    }
                }
                finally {
                    if (DeferredResult.this.timeoutResult != RESULT_NONE) {
                        continueProcessing = false;
                        try {
                            DeferredResult.this.setResultInternal(DeferredResult.this.timeoutResult);
                        }
                        catch (Throwable ex) {
                            logger.debug("Failed to handle timeout result", ex);
                        }
                    }
                }
                return continueProcessing;
            }

            public <S> void afterCompletion(NativeWebRequest request, DeferredResult<S> deferredResult) {
                DeferredResult.this.expired = true;
                if (DeferredResult.this.completionCallback != null) {
                    DeferredResult.this.completionCallback.run();
                }
            }
        };
    }

    public static interface DeferredResultHandler {
        public void handleResult(Object var1);
    }
}

