/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.accept.ServletPathExtensionContentNegotiationStrategy;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.DefaultResourceTransformerChain;
import org.springframework.web.servlet.resource.EncodedResource;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionedResource;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
EmbeddedValueResolverAware,
InitializingBean,
CorsConfigurationSource {
    private static final boolean contentLengthLongAvailable = ClassUtils.hasMethod(ServletResponse.class, "setContentLengthLong", Long.TYPE);
    private static final Log logger = LogFactory.getLog(ResourceHttpRequestHandler.class);
    private static final String URL_RESOURCE_CHARSET_PREFIX = "[charset=";
    private final List<String> locationValues = new ArrayList<String>(4);
    private final List<Resource> locations = new ArrayList<Resource>(4);
    private final Map<Resource, Charset> locationCharsets = new HashMap<Resource, Charset>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    private ResourceHttpMessageConverter resourceHttpMessageConverter;
    private ResourceRegionHttpMessageConverter resourceRegionHttpMessageConverter;
    private ContentNegotiationManager contentNegotiationManager;
    private PathExtensionContentNegotiationStrategy contentNegotiationStrategy;
    private CorsConfiguration corsConfiguration;
    private UrlPathHelper urlPathHelper;
    private StringValueResolver embeddedValueResolver;

    public ResourceHttpRequestHandler() {
        super(HttpMethod.GET.name(), HttpMethod.HEAD.name());
    }

    public void setLocationValues(List<String> locationValues) {
        Assert.notNull(locationValues, "Location values list must not be null");
        this.locationValues.clear();
        this.locationValues.addAll(locationValues);
    }

    public void setLocations(List<Resource> locations) {
        Assert.notNull(locations, "Locations list must not be null");
        this.locations.clear();
        this.locations.addAll(locations);
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public void setResourceResolvers(List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageConverter(ResourceHttpMessageConverter messageConverter) {
        this.resourceHttpMessageConverter = messageConverter;
    }

    public ResourceHttpMessageConverter getResourceHttpMessageConverter() {
        return this.resourceHttpMessageConverter;
    }

    public void setResourceRegionHttpMessageConverter(ResourceRegionHttpMessageConverter messageConverter) {
        this.resourceRegionHttpMessageConverter = messageConverter;
    }

    public ResourceRegionHttpMessageConverter getResourceRegionHttpMessageConverter() {
        return this.resourceRegionHttpMessageConverter;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setCorsConfiguration(CorsConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    @Override
    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        return this.corsConfiguration;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.resolveResourceLocations();
        if (logger.isWarnEnabled() && CollectionUtils.isEmpty(this.locations)) {
            logger.warn("Locations list is empty. No resources will be served unless a custom ResourceResolver is configured as an alternative to PathResourceResolver.");
        }
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.resourceHttpMessageConverter == null) {
            this.resourceHttpMessageConverter = new ResourceHttpMessageConverter();
        }
        if (this.resourceRegionHttpMessageConverter == null) {
            this.resourceRegionHttpMessageConverter = new ResourceRegionHttpMessageConverter();
        }
        this.contentNegotiationStrategy = this.initContentNegotiationStrategy();
    }

    private void resolveResourceLocations() {
        if (CollectionUtils.isEmpty(this.locationValues)) {
            return;
        }
        if (!CollectionUtils.isEmpty(this.locations)) {
            throw new IllegalArgumentException("Please set either Resource-based \"locations\" or String-based \"locationValues\", but not both.");
        }
        ApplicationContext applicationContext = this.getApplicationContext();
        for (String location : this.locationValues) {
            if (this.embeddedValueResolver != null) {
                String resolvedLocation = this.embeddedValueResolver.resolveStringValue(location);
                if (resolvedLocation == null) {
                    throw new IllegalArgumentException("Location resolved to null: " + location);
                }
                location = resolvedLocation;
            }
            Charset charset = null;
            if ((location = location.trim()).startsWith(URL_RESOURCE_CHARSET_PREFIX)) {
                int endIndex = location.indexOf(93, URL_RESOURCE_CHARSET_PREFIX.length());
                if (endIndex == -1) {
                    throw new IllegalArgumentException("Invalid charset syntax in location: " + location);
                }
                String value = location.substring(URL_RESOURCE_CHARSET_PREFIX.length(), endIndex);
                charset = Charset.forName(value);
                location = location.substring(endIndex + 1);
            }
            Resource resource = applicationContext.getResource(location);
            this.locations.add(resource);
            if (charset == null) continue;
            if (!(resource instanceof UrlResource)) {
                throw new IllegalArgumentException("Unexpected charset for non-UrlResource: " + resource);
            }
            this.locationCharsets.put(resource, charset);
        }
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.locations)) {
            return;
        }
        for (int i = this.getResourceResolvers().size() - 1; i >= 0; --i) {
            if (!(this.getResourceResolvers().get(i) instanceof PathResourceResolver)) continue;
            PathResourceResolver pathResolver = (PathResourceResolver)this.getResourceResolvers().get(i);
            if (ObjectUtils.isEmpty(pathResolver.getAllowedLocations())) {
                pathResolver.setAllowedLocations(this.getLocations().toArray(new Resource[this.getLocations().size()]));
            }
            if (this.urlPathHelper == null) break;
            pathResolver.setLocationCharsets(this.locationCharsets);
            pathResolver.setUrlPathHelper(this.urlPathHelper);
            break;
        }
    }

    protected PathExtensionContentNegotiationStrategy initContentNegotiationStrategy() {
        PathExtensionContentNegotiationStrategy strategy;
        HashMap<String, MediaType> mediaTypes = null;
        if (this.getContentNegotiationManager() != null && (strategy = this.getContentNegotiationManager().getStrategy(PathExtensionContentNegotiationStrategy.class)) != null) {
            mediaTypes = new HashMap<String, MediaType>(strategy.getMediaTypes());
        }
        return this.getServletContext() != null ? new ServletPathExtensionContentNegotiationStrategy(this.getServletContext(), mediaTypes) : new PathExtensionContentNegotiationStrategy(mediaTypes);
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Resource resource = this.getResource(request);
        if (resource == null) {
            logger.trace("No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setHeader("Allow", this.getAllowHeader());
            return;
        }
        this.checkRequest(request);
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            logger.trace("Resource not modified - returning 304");
            return;
        }
        this.prepareResponse(response);
        MediaType mediaType = this.getMediaType(request, resource);
        if (mediaType != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Determined media type '" + mediaType + "' for " + resource);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("No media type found for " + resource + " - not sending a content-type header");
        }
        if ("HEAD".equals(request.getMethod())) {
            this.setHeaders(response, resource, mediaType);
            logger.trace("HEAD request - skipping content");
            return;
        }
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        if (request.getHeader("Range") == null) {
            this.setHeaders(response, resource, mediaType);
            this.resourceHttpMessageConverter.write(resource, mediaType, outputMessage);
        } else {
            response.setHeader("Accept-Ranges", "bytes");
            ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request);
            try {
                List<HttpRange> httpRanges = inputMessage.getHeaders().getRange();
                response.setStatus(206);
                if (httpRanges.size() == 1) {
                    ResourceRegion resourceRegion = httpRanges.get(0).toResourceRegion(resource);
                    this.resourceRegionHttpMessageConverter.write(resourceRegion, mediaType, outputMessage);
                } else {
                    this.resourceRegionHttpMessageConverter.write(HttpRange.toResourceRegions(httpRanges, resource), mediaType, outputMessage);
                }
            }
            catch (IllegalArgumentException ex) {
                response.setHeader("Content-Range", "bytes */" + resource.contentLength());
                response.sendError(416);
            }
        }
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText(path = this.processPath(path)) || this.isInvalidPath(path)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring invalid resource path [" + path + "]");
            }
            return null;
        }
        if (this.isInvalidEncodedPath(path)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring invalid resource path with escape sequences [" + path + "]");
            }
            return null;
        }
        DefaultResourceResolverChain resolveChain = new DefaultResourceResolverChain(this.getResourceResolvers());
        Resource resource = resolveChain.resolveResource(request, path, this.getLocations());
        if (resource == null || this.getResourceTransformers().isEmpty()) {
            return resource;
        }
        DefaultResourceTransformerChain transformChain = new DefaultResourceTransformerChain(resolveChain, this.getResourceTransformers());
        resource = transformChain.transform(request, resource);
        return resource;
    }

    protected String processPath(String path) {
        path = StringUtils.replace(path, "\\", "/");
        path = this.cleanDuplicateSlashes(path);
        return this.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i = 0; i < path.length(); ++i) {
            char curr = path.charAt(i);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            String string = path = slash ? "/" + path.substring(i) : path.substring(i);
            if (logger.isTraceEnabled()) {
                logger.trace("Path after trimming leading '/' and control characters: [" + path + "]");
            }
            return path;
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidEncodedPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            logger.trace("Path contains \"WEB-INF\" or \"META-INF\".");
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl(relativePath) || relativePath.startsWith("url:")) {
                logger.trace("Path represents URL or has \"url:\" prefix.");
                return true;
            }
        }
        if (path.contains("..") && (path = StringUtils.cleanPath(path)).contains("../")) {
            logger.trace("Path contains \"../\" after call to StringUtils#cleanPath.");
            return true;
        }
        return false;
    }

    protected MediaType getMediaType(HttpServletRequest request, Resource resource) {
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            return mediaType;
        }
        return this.contentNegotiationStrategy.getMediaTypeForResource(resource);
    }

    @Deprecated
    protected MediaType getMediaType(Resource resource) {
        return null;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            if (contentLengthLongAvailable) {
                response.setContentLengthLong(length);
            } else {
                response.setHeader("Content-Length", Long.toString(length));
            }
        } else {
            response.setContentLength((int)length);
        }
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (resource instanceof EncodedResource) {
            response.setHeader("Content-Encoding", ((EncodedResource)resource).getContentEncoding());
        }
        if (resource instanceof VersionedResource) {
            response.setHeader("ETag", "\"" + ((VersionedResource)resource).getVersion() + "\"");
        }
        response.setHeader("Accept-Ranges", "bytes");
    }

    public String toString() {
        return "ResourceHttpRequestHandler [locations=" + this.getLocations() + ", resolvers=" + this.getResourceResolvers() + "]";
    }
}

