/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.livy;

import java.util.ArrayList;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.livy.LivyTypeEnum;
import org.apache.kylin.common.util.SourceConfigurationUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivyRestBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(LivyRestBuilder.class);
    private final KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
    private final Map<String, String> hiveConfProps = SourceConfigurationUtil.loadHiveConfiguration();
    private String url;
    private LivyTypeEnum livyTypeEnum;
    private Map<String, String> keys;
    private Map<String, String> arrs;
    private Map<String, String> maps;
    private ArrayList<String> args = new ArrayList();

    public LivyRestBuilder() {
        this.url = this.kylinConfig.getLivyUrl();
        this.keys = this.kylinConfig.getLivyKey();
        this.arrs = this.kylinConfig.getLivyArr();
        this.maps = this.kylinConfig.getLivyMap();
    }

    public String build() throws JSONException {
        try {
            JSONObject postJson = new JSONObject();
            if (LivyTypeEnum.sql.equals((Object)this.livyTypeEnum)) {
                postJson.put("className", (Object)"org.apache.kylin.engine.spark.SparkSqlOnLivyBatch");
                postJson.put("args", this.args);
            } else if (LivyTypeEnum.job.equals((Object)this.livyTypeEnum)) {
                postJson.put("className", (Object)"org.apache.kylin.common.util.SparkEntry");
                postJson.put("args", this.args);
            } else {
                throw new IllegalArgumentException("unSupport livy type.");
            }
            this.keys.forEach((key, value) -> {
                try {
                    postJson.put(key, value);
                }
                catch (JSONException e) {
                    logger.error("livy builder failed.", (Throwable)e);
                }
            });
            this.arrs.forEach((key, value) -> {
                try {
                    postJson.put(key, Lists.newArrayList(value.split(",")));
                }
                catch (JSONException e) {
                    logger.error("livy builder failed.", (Throwable)e);
                }
            });
            JSONObject confJson = new JSONObject();
            this.maps.forEach((key, value) -> {
                try {
                    confJson.put(key, value);
                }
                catch (JSONException e) {
                    logger.error("livy builder failed.", (Throwable)e);
                }
            });
            postJson.put("conf", (Object)confJson);
            return postJson.toString();
        }
        catch (JSONException e) {
            logger.error("livy builder failed.", (Throwable)e);
            throw new JSONException("create livy json error :" + e.getMessage());
        }
    }

    public void overwriteHiveProps(Map<String, String> overwrites) {
        this.hiveConfProps.putAll(overwrites);
    }

    public String parseProps() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, String> prop : this.hiveConfProps.entrySet()) {
            s.append("set ");
            s.append(prop.getKey());
            s.append("=");
            s.append(prop.getValue());
            s.append("; \n");
        }
        return s.toString();
    }

    public void addArgs(String arg) {
        this.args.add(arg);
    }

    public void addConf(String key, String value) {
        this.maps.put(key, value);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ArrayList<String> getArgs() {
        return this.args;
    }

    public void setArgs(ArrayList<String> args) {
        this.args = args;
    }

    public LivyTypeEnum getLivyTypeEnum() {
        return this.livyTypeEnum;
    }

    public void setLivyTypeEnum(LivyTypeEnum livyTypeEnum) {
        this.livyTypeEnum = livyTypeEnum;
    }
}

