/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.source.IReadableTable;

public class TableColumnValueSortedEnumerator
implements IDictionaryValueEnumerator {
    private Collection<IReadableTable.TableReader> readers;
    private int colIndex;
    private String colValue;
    private Comparator<String> comparator;
    private PriorityQueue<ReaderBuffer> pq;

    public TableColumnValueSortedEnumerator(Collection<IReadableTable.TableReader> readers, int colIndex, final Comparator<String> comparator) {
        this.readers = readers;
        this.colIndex = colIndex;
        this.comparator = comparator;
        this.pq = new PriorityQueue<ReaderBuffer>(11, new Comparator<ReaderBuffer>(){

            @Override
            public int compare(ReaderBuffer i, ReaderBuffer j) {
                boolean isEmpty1 = i.empty();
                boolean isEmpty2 = j.empty();
                if (isEmpty1 && isEmpty2) {
                    return 0;
                }
                if (isEmpty1 && !isEmpty2) {
                    return 1;
                }
                if (!isEmpty1 && isEmpty2) {
                    return -1;
                }
                return comparator.compare(i.peek(), j.peek());
            }
        });
        for (IReadableTable.TableReader reader : readers) {
            if (reader == null) continue;
            try {
                this.pq.add(new ReaderBuffer(reader));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean moveNext() throws IOException {
        if (!this.pq.isEmpty()) {
            String minEntry;
            ReaderBuffer buffer = this.pq.poll();
            this.colValue = minEntry = buffer.pop();
            if (buffer.empty()) {
                this.pq.remove(buffer);
            } else {
                this.pq.add(buffer);
            }
            return this.colValue != null;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        for (IReadableTable.TableReader reader : this.readers) {
            if (reader == null) continue;
            reader.close();
        }
    }

    @Override
    public String current() {
        return this.colValue;
    }

    final class ReaderBuffer {
        private String cache;
        private IReadableTable.TableReader reader;

        public ReaderBuffer(IReadableTable.TableReader reader) throws IOException {
            this.reader = reader;
            this.reload();
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        public boolean empty() {
            return this.cache == null;
        }

        public String peek() {
            return this.cache;
        }

        public String pop() throws IOException {
            String result = this.cache;
            this.reload();
            return result;
        }

        private void reload() throws IOException {
            if (this.reader.next()) {
                String[] split = this.reader.getRow();
                if (split.length == 1) {
                    this.cache = split[0];
                } else {
                    if (split.length <= TableColumnValueSortedEnumerator.this.colIndex) {
                        throw new ArrayIndexOutOfBoundsException("Column no. " + TableColumnValueSortedEnumerator.this.colIndex + " not found, line split is " + Arrays.asList(split));
                    }
                    this.cache = split[TableColumnValueSortedEnumerator.this.colIndex];
                }
            } else {
                this.cache = null;
            }
        }
    }
}

