/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.datagen;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.source.datagen.ColumnGenConfig;
import org.apache.kylin.source.datagen.ModelDataGenerator;

public class ColumnGenerator {
    private final ColumnGenConfig conf;
    private final ColumnDesc targetCol;
    private final int targetRows;
    private final Comparator<String> comp = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            if (ColumnGenerator.this.targetCol.getType().isNumberFamily()) {
                return Double.compare(Double.parseDouble(s1), Double.parseDouble(s2));
            }
            return s1.compareTo(s2);
        }
    };

    public ColumnGenerator(ColumnDesc col, int nRows, ModelDataGenerator modelGen) throws IOException {
        this.conf = new ColumnGenConfig(col, modelGen);
        this.targetCol = col;
        this.targetRows = nRows;
    }

    public Iterator<String> generate(long seed) {
        Base result = this.conf.isFK ? new DiscreteGen(this.conf.values, seed) : (this.conf.isID ? new IDGen(this.conf.idStart) : (this.conf.isRandom ? new RandomGen(this.targetCol, this.conf.randFormat, this.conf.randStart, this.conf.randEnd, this.conf.cardinality) : new DiscreteGen(this.conf.values)));
        if (this.conf.cardinality > 0) {
            result = new CardinalityFilter(result, this.conf.cardinality);
        }
        if (this.conf.genNull) {
            result = new AddNullFilter(result, this.conf.genNullPct, this.conf.genNullStr);
        }
        if (this.conf.order || this.conf.unique) {
            result = new OrderFilter(result, this.conf.unique, this.targetRows);
        }
        return result;
    }

    private class OrderFilter
    extends Base {
        private Iterator<String> iter;

        public OrderFilter(Iterator<String> input, boolean unique, int targetRows) {
            AbstractCollection cache = unique ? new TreeSet(ColumnGenerator.this.comp) : new ArrayList(targetRows);
            int cap = targetRows * 100;
            int i = 0;
            while (cache.size() < targetRows) {
                cache.add(input.next());
                if (i >= cap) {
                    throw new IllegalStateException();
                }
                ++i;
            }
            if (cache instanceof List) {
                Collections.sort((List)((Object)cache), ColumnGenerator.this.comp);
            }
            this.iter = cache.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public String next() {
            return this.iter.next();
        }
    }

    private class AddNullFilter
    extends Base {
        private Iterator<String> input;
        private double nullPct;
        private String nullStr;
        private Random rand;

        public AddNullFilter(Iterator<String> input, double nullPct, String nullStr) {
            this.input = input;
            this.nullPct = nullPct;
            this.nullStr = nullStr;
            this.rand = new Random();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            String r = this.nullStr;
            if (this.input.hasNext()) {
                r = this.input.next();
            }
            if (this.rand.nextDouble() < this.nullPct) {
                r = this.nullStr;
            }
            return r;
        }
    }

    private class CardinalityFilter
    extends Base {
        private Iterator<String> input;
        private int card;
        private TreeSet<String> cache;

        public CardinalityFilter(Iterator<String> input, int card) {
            assert (card > 0);
            this.input = input;
            this.card = card;
            this.cache = new TreeSet();
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public String next() {
            String r = this.input.next();
            if (this.cache.size() < this.card) {
                this.cache.add(r);
                return r;
            }
            return (r = this.cache.floor(r)) == null ? this.cache.first() : r;
        }
    }

    private class DiscreteGen
    extends Base {
        private List<String> values;
        private Random rand;

        public DiscreteGen(List<String> values) {
            this.values = values;
            this.rand = new Random();
        }

        public DiscreteGen(List<String> values, long seed) {
            this.values = values;
            this.rand = new Random(seed);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            if (this.values.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.values.get(this.rand.nextInt(this.values.size()));
        }
    }

    private class IDGen
    extends Base {
        int next;

        public IDGen(int start) {
            this.next = start;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return "" + this.next++;
        }
    }

    private class RandomGen
    extends Base {
        private DataType type;
        private String format;
        private int randStart;
        private int randEnd;
        private Random rand;

        public RandomGen(ColumnDesc col, String format, int randStart, int randEnd, int cardinality) {
            this.type = col.getType();
            if (this.type.isStringFamily()) {
                if (StringUtils.isBlank((CharSequence)format)) {
                    String name = col.getName();
                    format = name.substring(0, Math.min(4, name.length())) + "${RANDOM}";
                }
                Preconditions.checkArgument(format.contains("${RANDOM}"));
                this.initNumberRange(randStart, randEnd, cardinality);
            } else if (this.type.isTimeFamily()) {
                format = StringUtil.noBlank(format, "yyyy-MM-dd HH:mm:ss");
                this.initDateTimeRange(randStart, randEnd, 0);
            } else if (this.type.isDateTimeFamily()) {
                format = StringUtil.noBlank(format, "yyyy-MM-dd");
                this.initDateTimeRange(randStart, randEnd, cardinality);
            } else if (this.type.isIntegerFamily()) {
                this.initNumberRange(randStart, randEnd, cardinality);
                format = StringUtil.noBlank(format, "#");
            } else if (this.type.isNumberFamily()) {
                this.initNumberRange(randStart, randEnd, 0);
                format = StringUtil.noBlank(format, ".##");
            } else {
                throw new IllegalArgumentException();
            }
            this.format = format;
            this.rand = new Random();
        }

        private void initDateTimeRange(int randStart, int randEnd, int days) {
            if (randStart == 0 && randEnd == 0) {
                randStart = 2010;
                randEnd = 2015;
            }
            Preconditions.checkArgument(randStart < (randEnd = Math.max(randEnd, randStart + days / 365 + 1)));
            Preconditions.checkArgument((randEnd - randStart) * 365 >= days);
            this.randStart = randStart;
            this.randEnd = randEnd;
        }

        private void initNumberRange(int randStart, int randEnd, int cardinality) {
            if (randStart == 0 && randEnd == 0) {
                randStart = 0;
                randEnd = 1000;
            }
            Preconditions.checkArgument(randStart < (randEnd = Math.max(randEnd, randStart + cardinality)));
            Preconditions.checkArgument(randEnd - randStart >= cardinality);
            this.randStart = randStart;
            this.randEnd = randEnd;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            if (this.type.isStringFamily()) {
                return this.format.replace("${RANDOM}", "" + this.randomInt());
            }
            if (this.type.isTimeFamily()) {
                return DateFormat.formatToTimeStr(this.randomMillis(), this.format);
            }
            if (this.type.isDateTimeFamily()) {
                return DateFormat.formatToDateStr(this.randomMillis(), this.format);
            }
            if (this.type.isIntegerFamily()) {
                return this.formatNumber(this.randomInt());
            }
            if (this.type.isNumberFamily()) {
                return this.formatNumber(this.randomDouble());
            }
            throw new NoSuchElementException();
        }

        private String formatNumber(double i) {
            return new DecimalFormat(this.format, DecimalFormatSymbols.getInstance(Locale.ROOT)).format(i);
        }

        private int randomInt() {
            return this.randStart + this.rand.nextInt(this.randEnd - this.randStart);
        }

        private double randomDouble() {
            return (double)this.randomInt() + this.rand.nextDouble();
        }

        private long randomMillis() {
            int secondsInYear = 31536000;
            long year = (long)(this.randStart + this.rand.nextInt(this.randEnd - this.randStart)) - 1970L;
            long second = year * (long)secondsInYear + (long)this.rand.nextInt(secondsInYear);
            return second * 1000L;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Base
    implements Iterator<String> {
        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

