/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContextFacade {
    private static final Logger logger = LoggerFactory.getLogger(QueryContextFacade.class);
    private static final ConcurrentMap<String, QueryContext> RUNNING_CTX_MAP = Maps.newConcurrentMap();
    private static final InternalThreadLocal<QueryContext> CURRENT_CTX = new InternalThreadLocal<QueryContext>(){

        @Override
        protected QueryContext initialValue() {
            QueryContext queryContext = new QueryContext(KylinConfig.getInstanceFromEnv().getHBaseMaxConnectionThreadsPerQuery());
            RUNNING_CTX_MAP.put(queryContext.getQueryId(), queryContext);
            return queryContext;
        }
    };

    public static QueryContext current() {
        return CURRENT_CTX.get();
    }

    public static void resetCurrent() {
        QueryContext queryContext = CURRENT_CTX.get();
        if (queryContext != null) {
            RUNNING_CTX_MAP.remove(queryContext.getQueryId());
            CURRENT_CTX.remove();
        }
    }

    public static void stopQuery(String queryId, String info) {
        QueryContext queryContext = (QueryContext)RUNNING_CTX_MAP.get(queryId);
        if (queryContext != null) {
            queryContext.stopEarly(info);
        } else {
            logger.info("the query:{} is not existed", (Object)queryId);
        }
    }

    public static TreeSet<QueryContext> getAllRunningQueries() {
        TreeSet<QueryContext> runningQueries = Sets.newTreeSet(new Comparator<QueryContext>(){

            @Override
            public int compare(QueryContext o1, QueryContext o2) {
                if (o2.getAccumulatedMillis() > o1.getAccumulatedMillis()) {
                    return 1;
                }
                if (o2.getAccumulatedMillis() < o1.getAccumulatedMillis()) {
                    return -1;
                }
                return o1.getQueryId().compareTo(o2.getQueryId());
            }
        });
        runningQueries.addAll(RUNNING_CTX_MAP.values());
        return runningQueries;
    }

    public static TreeSet<QueryContext> getLongRunningQueries(long runningTime) {
        TreeSet<QueryContext> allRunningQueries = QueryContextFacade.getAllRunningQueries();
        QueryContext tmpCtx = new QueryContext(KylinConfig.getInstanceFromEnv().getHBaseMaxConnectionThreadsPerQuery(), runningTime + 1L);
        return (TreeSet)allRunningQueries.headSet(tmpCtx);
    }
}

