/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer;

import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.buffer.MappeableRunContainer;

final class MappeableRunContainerShortIterator
implements PeekableShortIterator {
    int pos;
    int le = 0;
    int maxlength;
    int base;
    MappeableRunContainer parent;

    MappeableRunContainerShortIterator() {
    }

    MappeableRunContainerShortIterator(MappeableRunContainer p) {
        this.wrap(p);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.nbrruns;
    }

    @Override
    public short next() {
        short ans = (short)(this.base + this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    void wrap(MappeableRunContainer p) {
        this.parent = p;
        this.pos = 0;
        this.le = 0;
        if (this.pos < this.parent.nbrruns) {
            this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
            this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
        }
    }

    @Override
    public void advanceIfNeeded(short minval) {
        while (this.base + this.maxlength < BufferUtil.toIntUnsigned(minval)) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = BufferUtil.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.parent.getValue(this.pos));
                continue;
            }
            return;
        }
        if (this.base > BufferUtil.toIntUnsigned(minval)) {
            return;
        }
        this.le = BufferUtil.toIntUnsigned(minval) - this.base;
    }

    @Override
    public short peekNext() {
        return (short)(this.base + this.le);
    }
}

