/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISegmentAdvisor;
import org.apache.kylin.metadata.model.SegmentRange;

public class CubeSegmentAdvisor
implements ISegmentAdvisor {
    protected final CubeSegment seg;
    protected SegmentRange.TSRange tsRange;
    protected SegmentRange segRange;

    public CubeSegmentAdvisor(ISegment segment) {
        this.seg = (CubeSegment)segment;
    }

    @Override
    public boolean isOffsetCube() {
        return this.seg._getSourceOffsetStart() != 0L || this.seg._getSourceOffsetEnd() != 0L;
    }

    @Override
    public SegmentRange getSegRange() {
        if (this.segRange != null) {
            return this.segRange;
        }
        this.segRange = this.isOffsetCube() ? new SegmentRange<Long>(this.seg._getSourceOffsetStart(), this.seg._getSourceOffsetEnd()) : this.getTSRange();
        return this.segRange;
    }

    @Override
    public void setSegRange(SegmentRange range) {
        if (range == null) {
            this.seg._setSourceOffsetStart(0L);
            this.seg._setSourceOffsetEnd(0L);
        } else {
            this.seg._setSourceOffsetStart((Long)range.start.v);
            this.seg._setSourceOffsetEnd((Long)range.end.v);
        }
        this.clear();
    }

    @Override
    public SegmentRange.TSRange getTSRange() {
        if (this.tsRange != null) {
            return this.tsRange;
        }
        this.tsRange = new SegmentRange.TSRange(this.seg._getDateRangeStart(), this.seg._getDateRangeEnd());
        return this.tsRange;
    }

    @Override
    public void setTSRange(SegmentRange.TSRange range) {
        if (range == null) {
            this.seg._setDateRangeStart(0L);
            this.seg._setDateRangeEnd(0L);
        } else {
            this.seg._setDateRangeStart((Long)range.start.v);
            this.seg._setDateRangeEnd((Long)range.end.v);
        }
        this.clear();
    }

    private void clear() {
        this.tsRange = null;
        this.segRange = null;
    }
}

