/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.source.IReadableTable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DictionaryInfo
extends RootPersistentEntity {
    @JsonProperty(value="source_table")
    private String sourceTable;
    @JsonProperty(value="source_column")
    private String sourceColumn;
    @JsonProperty(value="source_column_index")
    private int sourceColumnIndex;
    @JsonProperty(value="data_type")
    private String dataType;
    @JsonProperty(value="input")
    private IReadableTable.TableSignature input;
    @JsonProperty(value="dictionary_class")
    private String dictionaryClass;
    @JsonProperty(value="cardinality")
    private int cardinality;
    transient Dictionary<String> dictionaryObject;

    public DictionaryInfo() {
    }

    public DictionaryInfo(ColumnDesc col, String dataType) {
        this(col.getTable().getIdentity(), col.getName(), col.getZeroBasedIndex(), dataType, null);
    }

    public DictionaryInfo(ColumnDesc col, String dataType, IReadableTable.TableSignature input) {
        this(col.getTable().getIdentity(), col.getName(), col.getZeroBasedIndex(), dataType, input);
    }

    public DictionaryInfo(String sourceTable, String sourceColumn, int sourceColumnIndex, String dataType, IReadableTable.TableSignature input) {
        this.updateRandomUuid();
        this.sourceTable = sourceTable;
        this.sourceColumn = sourceColumn;
        this.sourceColumnIndex = sourceColumnIndex;
        this.dataType = dataType;
        this.input = input;
    }

    public DictionaryInfo(DictionaryInfo other) {
        this.updateRandomUuid();
        this.sourceTable = other.sourceTable;
        this.sourceColumn = other.sourceColumn;
        this.sourceColumnIndex = other.sourceColumnIndex;
        this.dataType = other.dataType;
        this.input = other.input;
    }

    public String getResourcePath() {
        return "/dict/" + this.sourceTable + "/" + this.sourceColumn + "/" + this.uuid + ".dict";
    }

    public String getResourceDir() {
        return "/dict/" + this.sourceTable + "/" + this.sourceColumn;
    }

    public boolean isDictOnSameColumn(DictionaryInfo other) {
        return this.sourceTable.equalsIgnoreCase(other.sourceTable) && this.sourceColumn.equalsIgnoreCase(other.sourceColumn) && this.sourceColumnIndex == other.sourceColumnIndex && this.dataType.equalsIgnoreCase(other.dataType) && this.dictionaryClass.equalsIgnoreCase(other.dictionaryClass);
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(String sourceColumn) {
        this.sourceColumn = sourceColumn;
    }

    public int getSourceColumnIndex() {
        return this.sourceColumnIndex;
    }

    public void setSourceColumnIndex(int sourceColumnIndex) {
        this.sourceColumnIndex = sourceColumnIndex;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public IReadableTable.TableSignature getInput() {
        return this.input;
    }

    public void setInput(IReadableTable.TableSignature input) {
        this.input = input;
    }

    public String getDictionaryClass() {
        return this.dictionaryClass;
    }

    public void setDictionaryClass(String dictionaryClass) {
        this.dictionaryClass = dictionaryClass;
    }

    public Dictionary<String> getDictionaryObject() {
        return this.dictionaryObject;
    }

    public void setDictionaryObject(Dictionary<String> dictionaryObject) {
        this.dictionaryObject = dictionaryObject;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }
}

