/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.IOException;
import java.util.Iterator;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTAggregateTransformScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;

public class GTTwoLayerAggregateScanner
implements IGTScanner {
    protected final IGTScanner inputScanner;
    private final GTAggregateTransformScanner secondLayerInputScanner;
    private final GTAggregateScanner outputScanner;

    public GTTwoLayerAggregateScanner(IGTScanner inputScanner, GTScanRequest req, boolean spillEnabled) {
        this.inputScanner = inputScanner;
        this.secondLayerInputScanner = new GTAggregateTransformScanner(inputScanner, req);
        this.outputScanner = new GTAggregateScanner(this.secondLayerInputScanner, req, spillEnabled);
    }

    @Override
    public GTInfo getInfo() {
        return this.inputScanner.getInfo();
    }

    @Override
    public void close() throws IOException {
        this.inputScanner.close();
        this.secondLayerInputScanner.close();
        this.outputScanner.close();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        return this.outputScanner.iterator();
    }

    public long getFirstLayerInputRowCount() {
        return this.secondLayerInputScanner.getInputRowCount();
    }

    public long getSecondLayerInputRowCount() {
        return this.outputScanner.getInputRowCount();
    }
}

