/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.util.Set;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dict.DictCodeSystem;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.storage.hbase.common.coprocessor.FilterDecorator;

public class CoprocessorFilter {
    private final TupleFilter filter;
    private final Set<TblColRef> inevaluableColumns;

    public static CoprocessorFilter fromFilter(IDimensionEncodingMap dimEncMap, TupleFilter rootFilter, FilterDecorator.FilterConstantsTreatment filterConstantsTreatment) {
        FilterDecorator filterDecorator = new FilterDecorator(dimEncMap, filterConstantsTreatment);
        byte[] bytes = TupleFilterSerializer.serialize(rootFilter, filterDecorator, DictCodeSystem.INSTANCE);
        TupleFilter copy = TupleFilterSerializer.deserialize(bytes, DictCodeSystem.INSTANCE);
        return new CoprocessorFilter(copy, filterDecorator.getInevaluableColumns());
    }

    public static byte[] serialize(CoprocessorFilter o) {
        return o.filter == null ? BytesUtil.EMPTY_BYTE_ARRAY : TupleFilterSerializer.serialize(o.filter, DictCodeSystem.INSTANCE);
    }

    public static CoprocessorFilter deserialize(byte[] filterBytes) {
        TupleFilter filter = filterBytes == null || filterBytes.length == 0 ? null : TupleFilterSerializer.deserialize(filterBytes, DictCodeSystem.INSTANCE);
        return new CoprocessorFilter(filter, null);
    }

    public CoprocessorFilter(TupleFilter filter, Set<TblColRef> inevaluableColumns) {
        this.filter = filter;
        this.inevaluableColumns = inevaluableColumns;
    }

    public TupleFilter getFilter() {
        return this.filter;
    }

    public Set<TblColRef> getInevaluableColumns() {
        return this.inevaluableColumns;
    }

    public boolean evaluate(IEvaluatableTuple tuple) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.evaluate(tuple, DictCodeSystem.INSTANCE);
    }
}

