/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.common.coprocessor.AggrKey;

public class CoprocessorProjector {
    private static final BytesSerializer<CoprocessorProjector> serializer = new BytesSerializer<CoprocessorProjector>(){

        @Override
        public void serialize(CoprocessorProjector value, ByteBuffer out) {
            BytesUtil.writeByteArray(value.groupByMask, out);
            BytesUtil.writeVInt(value.hasGroupby ? 1 : 0, out);
        }

        @Override
        public CoprocessorProjector deserialize(ByteBuffer in) {
            byte[] mask = BytesUtil.readByteArray(in);
            boolean hasGroupBy = BytesUtil.readVInt(in) == 1;
            return new CoprocessorProjector(mask, hasGroupBy);
        }
    };
    final transient AggrKey aggrKey;
    final byte[] groupByMask;
    final boolean hasGroupby;

    public static CoprocessorProjector makeForObserver(CubeSegment cubeSegment, Cuboid cuboid, final Collection<TblColRef> dimensionColumns) {
        RowKeyEncoder rowKeyMaskEncoder = new RowKeyEncoder(cubeSegment, cuboid){

            @Override
            public void fillHeader(byte[] bytes) {
                Arrays.fill(bytes, 0, this.getHeaderLength(), (byte)-1);
            }

            @Override
            protected void fillColumnValue(TblColRef column, int columnLen, String valueStr, byte[] outputValue, int outputValueOffset) {
                byte bits = dimensionColumns.contains(column) ? (byte)-1 : 0;
                Arrays.fill(outputValue, outputValueOffset, outputValueOffset + columnLen, bits);
            }
        };
        byte[] mask = rowKeyMaskEncoder.encode(new String[cuboid.getColumns().size()]);
        return new CoprocessorProjector(mask, dimensionColumns.size() != 0);
    }

    public static byte[] serialize(CoprocessorProjector o) {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        serializer.serialize(o, buf);
        byte[] result = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, result, 0, buf.position());
        return result;
    }

    public static CoprocessorProjector deserialize(byte[] bytes) {
        return serializer.deserialize(ByteBuffer.wrap(bytes));
    }

    public CoprocessorProjector(byte[] groupByMask, boolean hasGroupby) {
        this.groupByMask = groupByMask;
        this.aggrKey = new AggrKey(groupByMask);
        this.hasGroupby = hasGroupby;
    }

    public boolean hasGroupby() {
        return this.hasGroupby;
    }

    public AggrKey getAggrKey(List<Cell> rowCells) {
        Cell cell = rowCells.get(0);
        assert (this.groupByMask.length == cell.getRowLength());
        this.aggrKey.set(cell.getRowArray(), cell.getRowOffset());
        return this.aggrKey;
    }

    public AggrKey getAggrKey(byte[] row) {
        assert (this.groupByMask.length == row.length);
        this.aggrKey.set(row, 0);
        return this.aggrKey;
    }
}

