/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanUtil {
    private static final Logger logger = LoggerFactory.getLogger(StorageCleanUtil.class);

    public static void dropHTables(HBaseAdmin hbaseAdmin, List<String> hTables) {
        StorageCleanUtil.runSingleThreadTaskQuietly(() -> {
            try {
                for (String htable : hTables) {
                    logger.info("Deleting HBase table {}", (Object)htable);
                    if (hbaseAdmin.tableExists(htable)) {
                        if (hbaseAdmin.isTableEnabled(htable)) {
                            hbaseAdmin.disableTable(htable);
                        }
                        hbaseAdmin.deleteTable(htable);
                        logger.info("Deleted HBase table {}", (Object)htable);
                        continue;
                    }
                    logger.info("HBase table {} does not exist.", (Object)htable);
                }
            }
            catch (Exception e) {
                logger.error("Deleting HBase table failed");
            }
            finally {
                IOUtils.closeQuietly((Closeable)hbaseAdmin);
            }
        });
    }

    public static void deleteHDFSPath(FileSystem fileSystem, List<String> hdfsPaths) {
        StorageCleanUtil.runSingleThreadTaskQuietly(() -> {
            try {
                for (String hdfsPath : hdfsPaths) {
                    logger.info("Deleting HDFS path {}", (Object)hdfsPath);
                    Path path = new Path(hdfsPath);
                    if (!fileSystem.exists(path)) continue;
                    fileSystem.delete(path, true);
                    logger.info("Deleted HDFS path {}", (Object)hdfsPath);
                }
            }
            catch (Exception e) {
                logger.error("Deleting HDFS path failed");
            }
        });
    }

    private static void runSingleThreadTaskQuietly(Runnable task) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            executorService.execute(task);
        }
        catch (Exception e) {
            logger.error("Failed to run task", (Throwable)e);
        }
        finally {
            executorService.shutdown();
        }
    }
}

