/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMsgProducer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMsgProducer.class);
    private static Producer<String, String> producer;
    private static Map<String, String> kafkaConfig;
    private static String TOPIC_NAME;
    private static final Properties kafkaProperties;

    private KafkaMsgProducer() {
        this.init();
    }

    public static final KafkaMsgProducer getInstance() {
        return BasicProducerHolder.INSTANCE;
    }

    public void init() {
        if (null == kafkaConfig) {
            kafkaConfig = KylinConfig.getInstanceFromEnv().getJobStatusKafkaConfig();
        }
        if (null == producer) {
            kafkaProperties.put("bootstrap.servers", kafkaConfig.get("bootstrap.servers"));
            for (Map.Entry<String, String> entry : kafkaConfig.entrySet()) {
                kafkaProperties.put(entry.getKey(), entry.getValue());
            }
            producer = new KafkaProducer(kafkaProperties);
        }
        if (null == TOPIC_NAME) {
            TOPIC_NAME = kafkaConfig.get("topic.name");
        }
    }

    public void sendJobStatusMessage(String message) {
        this.sendMessage(message);
    }

    private void sendMessage(String message) {
        ProducerRecord record = new ProducerRecord(TOPIC_NAME, (Object)message);
        producer.send(record, (recordMetadata, exception) -> {
            if (null != exception) {
                logger.error("kafka send message error.", exception);
            }
        });
    }

    static {
        kafkaProperties = new Properties();
        kafkaProperties.put("acks", "-1");
        kafkaProperties.put("retries", (Object)3);
        kafkaProperties.put("compression.type", "lz4");
        kafkaProperties.put("linger.ms", (Object)500);
        kafkaProperties.put("batch.size", (Object)10000);
        kafkaProperties.put("max.in.flight.requests.per.connection", (Object)1);
    }

    private static class BasicProducerHolder {
        private static final KafkaMsgProducer INSTANCE = new KafkaMsgProducer();

        private BasicProducerHolder() {
        }
    }
}

