/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;

public class DictCodeSystem
implements IFilterCodeSystem<String> {
    public static final DictCodeSystem INSTANCE = new DictCodeSystem();

    private DictCodeSystem() {
    }

    @Override
    public boolean isNull(String value) {
        if (value == null) {
            return true;
        }
        String v = value;
        int n = v.length();
        for (int i = 0; i < n; ++i) {
            if ((byte)v.charAt(i) == -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(String tupleValue, String constValue) {
        return tupleValue.compareTo(constValue);
    }

    @Override
    public void serialize(String value, ByteBuffer buffer) {
        BytesUtil.writeUTFString(value, buffer);
    }

    @Override
    public String deserialize(ByteBuffer buffer) {
        return BytesUtil.readUTFString(buffer);
    }
}

