/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class BooleanDimEnc
extends DimensionEncoding
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ENCODING_NAME = "boolean";
    public static String[] ALLOWED_VALUES = new String[]{"", "true", "false", "TRUE", "FALSE", "True", "False", "t", "f", "T", "F", "yes", "no", "YES", "NO", "Yes", "No", "y", "n", "Y", "N", "1", "0"};
    public static final Map<String, Integer> map = Maps.newHashMap();
    private int fixedLen = 1;

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(String value, byte[] output, int outputOffset) {
        if (value == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        Integer encodeValue = map.get(value);
        if (encodeValue == null) {
            throw new IllegalArgumentException("Value '" + value + "' is not a recognized boolean value.");
        }
        BytesUtil.writeLong(encodeValue.intValue(), output, outputOffset, this.fixedLen);
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        if (BooleanDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        int x = (int)BytesUtil.readLong(bytes, offset, len);
        if (x >= ALLOWED_VALUES.length) {
            throw new IllegalStateException();
        }
        return ALLOWED_VALUES[x];
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new BooleanSerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.fixedLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readShort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.fixedLen;
    }

    static {
        for (int i = 0; i < ALLOWED_VALUES.length; ++i) {
            map.put(ALLOWED_VALUES[i], i);
        }
    }

    public class BooleanSerializer
    extends DataTypeSerializer<Object> {
        private byte[] currentBuf() {
            byte[] buf = (byte[])this.current.get();
            if (buf == null) {
                buf = new byte[BooleanDimEnc.this.fixedLen];
                this.current.set(buf);
            }
            return buf;
        }

        @Override
        public void serialize(Object value, ByteBuffer out) {
            byte[] buf = this.currentBuf();
            String valueStr = value == null ? null : value.toString();
            BooleanDimEnc.this.encode(valueStr, buf, 0);
            out.put(buf);
        }

        @Override
        public Object deserialize(ByteBuffer in) {
            byte[] buf = this.currentBuf();
            in.get(buf);
            return BooleanDimEnc.this.decode(buf, 0, buf.length);
        }

        @Override
        public int peekLength(ByteBuffer in) {
            return BooleanDimEnc.this.fixedLen;
        }

        @Override
        public int maxLength() {
            return BooleanDimEnc.this.fixedLen;
        }

        @Override
        public int getStorageBytesEstimate() {
            return BooleanDimEnc.this.fixedLen;
        }

        @Override
        public Object valueOf(String str) {
            return str;
        }
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return BooleanDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new BooleanDimEnc();
        }

        @Override
        public boolean isValidDimensionEncoding(String encodingName, String[] args) {
            return true;
        }
    }
}

