/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopOutputFormat;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.flink.FlinkBatchCubingJobBuilder2;
import org.apache.kylin.engine.flink.FlinkUtil;
import org.apache.kylin.engine.flink.util.PercentileCounterSerializer;
import org.apache.kylin.engine.mr.BatchCubingJobBuilder2;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.BaseCuboidBuilder;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.NDCuboidBuilder;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCubingByLayer
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(FlinkCubingByLayer.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_OUTPUT_PATH;
    public static final Option OPTION_INPUT_TABLE;
    public static final Option OPTION_INPUT_PATH;
    public static final Option OPTION_ENABLE_OBJECT_REUSE;
    private Options options = new Options();

    public FlinkCubingByLayer() {
        this.options.addOption(OPTION_INPUT_TABLE);
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_OUTPUT_PATH);
        this.options.addOption(OPTION_ENABLE_OBJECT_REUSE);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        BaseCuboidReduceGroupFunction baseCuboidReducerFunction;
        String metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        String hiveTable = optionsHelper.getOptionValue(OPTION_INPUT_TABLE);
        String inputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH);
        String enableObjectReuseOptValue = optionsHelper.getOptionValue(OPTION_ENABLE_OBJECT_REUSE);
        boolean enableObjectReuse = false;
        if (enableObjectReuseOptValue != null && !enableObjectReuseOptValue.isEmpty()) {
            enableObjectReuse = true;
        }
        Job job = Job.getInstance();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        HadoopUtil.deletePath(job.getConfiguration(), new Path(outputPath));
        SerializableConfiguration sConf = new SerializableConfiguration(job.getConfiguration());
        KylinConfig envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
        CubeInstance cubeInstance = CubeManager.getInstance(envConfig).getCube(cubeName);
        CubeDesc cubeDesc = cubeInstance.getDescriptor();
        CubeSegment cubeSegment = cubeInstance.getSegmentById(segmentId);
        logger.info("DataSet input path : {}", (Object)inputPath);
        logger.info("DataSet output path : {}", (Object)outputPath);
        int countMeasureIndex = 0;
        for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
            if (measureDesc.getFunction().isCount()) break;
            ++countMeasureIndex;
        }
        CubeStatsReader cubeStatsReader = new CubeStatsReader(cubeSegment, envConfig);
        boolean[] needAggr = new boolean[cubeDesc.getMeasures().size()];
        boolean allNormalMeasure = true;
        for (int i = 0; i < cubeDesc.getMeasures().size(); ++i) {
            needAggr[i] = !cubeDesc.getMeasures().get(i).getFunction().getMeasureType().onlyAggrInBaseCuboid();
            allNormalMeasure = allNormalMeasure && needAggr[i];
        }
        logger.info("All measure are normal (agg on all cuboids) ? : " + allNormalMeasure);
        boolean isSequenceFile = "SEQUENCEFILE".equalsIgnoreCase(envConfig.getFlatTableStorageFormat());
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (enableObjectReuse) {
            env.getConfig().enableObjectReuse();
        }
        env.getConfig().registerKryoType(PercentileCounter.class);
        env.getConfig().registerTypeWithKryoSerializer(PercentileCounter.class, PercentileCounterSerializer.class);
        DataSet<String[]> hiveDataSet = FlinkUtil.readHiveRecords(isSequenceFile, env, inputPath, hiveTable, job);
        MapPartitionOperator encodedBaseDataSet = hiveDataSet.mapPartition((MapPartitionFunction)new EncodeBaseCuboidMapPartitionFunction(cubeName, segmentId, metaUrl, sConf));
        Long totalCount = 0L;
        if (envConfig.isFlinkSanityCheckEnabled()) {
            totalCount = encodedBaseDataSet.count();
        }
        BaseCuboidReduceGroupFunction reducerFunction = baseCuboidReducerFunction = new BaseCuboidReduceGroupFunction(cubeName, metaUrl, sConf);
        if (!allNormalMeasure) {
            reducerFunction = new CuboidReduceGroupFunction(cubeName, metaUrl, sConf, needAggr);
        }
        int totalLevels = cubeSegment.getCuboidScheduler().getBuildLevel();
        DataSet[] allDataSets = new DataSet[totalLevels + 1];
        int level = 0;
        allDataSets[0] = encodedBaseDataSet.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)baseCuboidReducerFunction);
        this.sinkToHDFS((DataSet<Tuple2<ByteArray, Object[]>>)allDataSets[0], metaUrl, cubeName, cubeSegment, outputPath, 0, Job.getInstance(), envConfig);
        CuboidMapPartitionFunction mapPartitionFunction = new CuboidMapPartitionFunction(cubeName, segmentId, metaUrl, sConf);
        for (level = 1; level <= totalLevels; ++level) {
            allDataSets[level] = allDataSets[level - 1].mapPartition((MapPartitionFunction)mapPartitionFunction).groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)reducerFunction);
            if (envConfig.isFlinkSanityCheckEnabled()) {
                this.sanityCheck((DataSet<Tuple2<ByteArray, Object[]>>)allDataSets[level], totalCount, level, cubeStatsReader, countMeasureIndex);
            }
            this.sinkToHDFS((DataSet<Tuple2<ByteArray, Object[]>>)allDataSets[level], metaUrl, cubeName, cubeSegment, outputPath, level, Job.getInstance(), envConfig);
        }
        env.execute("Cubing for : " + cubeName + " segment " + segmentId);
        logger.info("Finished on calculating all level cuboids.");
        logger.info("HDFS: Number of bytes written=" + FlinkBatchCubingJobBuilder2.getFileSize(outputPath, fs));
    }

    private void sinkToHDFS(DataSet<Tuple2<ByteArray, Object[]>> dataSet, final String metaUrl, final String cubeName, CubeSegment cubeSeg, String hdfsBaseLocation, int level, Job job, KylinConfig kylinConfig) throws Exception {
        String cuboidOutputPath = BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(hdfsBaseLocation, level);
        final SerializableConfiguration sConf = new SerializableConfiguration(job.getConfiguration());
        FlinkUtil.modifyFlinkHadoopConfiguration(job);
        FlinkUtil.setHadoopConfForCuboid(job, cubeSeg, metaUrl);
        HadoopOutputFormat hadoopOF = new HadoopOutputFormat((OutputFormat)new SequenceFileOutputFormat(), job);
        SequenceFileOutputFormat.setOutputPath((Job)job, (Path)new Path(cuboidOutputPath));
        dataSet.map((MapFunction)new RichMapFunction<Tuple2<ByteArray, Object[]>, Tuple2<Text, Text>>(){
            BufferedMeasureCodec codec;

            public void open(Configuration parameters) throws Exception {
                KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
                try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kylinConfig);){
                    CubeDesc desc = CubeDescManager.getInstance(kylinConfig).getCubeDesc(cubeName);
                    this.codec = new BufferedMeasureCodec(desc.getMeasures());
                }
            }

            public Tuple2<Text, Text> map(Tuple2<ByteArray, Object[]> tuple2) throws Exception {
                ByteBuffer valueBuf = this.codec.encode((Object[])tuple2.f1);
                Text textResult = new Text();
                textResult.set(valueBuf.array(), 0, valueBuf.position());
                return new Tuple2((Object)new Text(((ByteArray)tuple2.f0).array()), (Object)textResult);
            }
        }).output((org.apache.flink.api.common.io.OutputFormat)hadoopOF);
        logger.info("Persisting DataSet for level " + level + " into " + cuboidOutputPath);
    }

    private void sanityCheck(DataSet<Tuple2<ByteArray, Object[]>> dataSet, Long totalCount, int thisLevel, CubeStatsReader cubeStatsReader, int countMeasureIndex) throws Exception {
        int thisCuboidNum = cubeStatsReader.getCuboidsByLayer(thisLevel).size();
        Long count2 = this.getDataSetCountSum(dataSet, countMeasureIndex);
        if (count2 != totalCount * (long)thisCuboidNum) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Sanity check failed, level %s, total count(*) is %s; cuboid number %s", thisLevel, count2, thisCuboidNum));
        }
        logger.info("sanity check success for level " + thisLevel + ", count(*) is " + count2 / (long)thisCuboidNum);
    }

    private Long getDataSetCountSum(DataSet<Tuple2<ByteArray, Object[]>> dataSet, int countMeasureIndex) throws Exception {
        Long count = dataSet.map((MapFunction & Serializable)byteArrayTuple2 -> new Tuple2(byteArrayTuple2.f0, (Object)((Long)((Object[])byteArrayTuple2.f1)[countMeasureIndex]))).sum(1).count();
        return count;
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segment");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"hiveTable");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Hive Intermediate Table");
        OPTION_INPUT_TABLE = OptionBuilder.create((String)"hiveTable");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Hive Intermediate Table PATH");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"enableObjectReuse");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Enable object reuse");
        OPTION_ENABLE_OBJECT_REUSE = OptionBuilder.create((String)"enableObjectReuse");
    }

    private static class CuboidFlatMapFunction
    extends RichFlatMapFunction<Tuple2<ByteArray, Object[]>, Tuple2<ByteArray, Object[]>> {
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private CubeSegment cubeSegment;
        private CubeDesc cubeDesc;
        private NDCuboidBuilder ndCuboidBuilder;
        private RowKeySplitter rowKeySplitter;
        private SerializableConfiguration conf;

        public CuboidFlatMapFunction(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                this.cubeSegment = cubeInstance.getSegmentById(this.segmentId);
                this.cubeDesc = cubeInstance.getDescriptor();
                this.ndCuboidBuilder = new NDCuboidBuilder(this.cubeSegment, new RowKeyEncoderProvider(this.cubeSegment));
                this.rowKeySplitter = new RowKeySplitter(this.cubeSegment);
            }
        }

        public void flatMap(Tuple2<ByteArray, Object[]> tuple2, Collector<Tuple2<ByteArray, Object[]>> collector) throws Exception {
            byte[] key = ((ByteArray)tuple2.f0).array();
            long cuboidId = this.rowKeySplitter.parseCuboid(key);
            List<Long> myChildren = this.cubeSegment.getCuboidScheduler().getSpanningCuboid(cuboidId);
            if (myChildren == null || myChildren.size() == 0) {
                return;
            }
            this.rowKeySplitter.split(key);
            Cuboid parentCuboid = Cuboid.findForMandatory(this.cubeDesc, cuboidId);
            for (Long child : myChildren) {
                Cuboid childCuboid = Cuboid.findForMandatory(this.cubeDesc, child);
                ByteArray result = this.ndCuboidBuilder.buildKey2(parentCuboid, childCuboid, this.rowKeySplitter.getSplitBuffers());
                collector.collect((Object)new Tuple2((Object)result, tuple2.f1));
            }
        }
    }

    private static class CuboidMapPartitionFunction
    extends RichMapPartitionFunction<Tuple2<ByteArray, Object[]>, Tuple2<ByteArray, Object[]>> {
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private CubeSegment cubeSegment;
        private CubeDesc cubeDesc;
        private NDCuboidBuilder ndCuboidBuilder;
        private RowKeySplitter rowKeySplitter;
        private SerializableConfiguration conf;

        public CuboidMapPartitionFunction(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                this.cubeSegment = cubeInstance.getSegmentById(this.segmentId);
                this.cubeDesc = cubeInstance.getDescriptor();
                this.ndCuboidBuilder = new NDCuboidBuilder(this.cubeSegment, new RowKeyEncoderProvider(this.cubeSegment));
                this.rowKeySplitter = new RowKeySplitter(this.cubeSegment);
            }
        }

        public void mapPartition(Iterable<Tuple2<ByteArray, Object[]>> iterable, Collector<Tuple2<ByteArray, Object[]>> collector) throws Exception {
            for (Tuple2<ByteArray, Object[]> item : iterable) {
                byte[] key = ((ByteArray)item.f0).array();
                long cuboidId = this.rowKeySplitter.parseCuboid(key);
                List<Long> myChildren = this.cubeSegment.getCuboidScheduler().getSpanningCuboid(cuboidId);
                if (myChildren == null || myChildren.size() == 0) continue;
                this.rowKeySplitter.split(key);
                Cuboid parentCuboid = Cuboid.findForMandatory(this.cubeDesc, cuboidId);
                for (Long child : myChildren) {
                    Cuboid childCuboid = Cuboid.findForMandatory(this.cubeDesc, child);
                    ByteArray result = this.ndCuboidBuilder.buildKey2(parentCuboid, childCuboid, this.rowKeySplitter.getSplitBuffers());
                    collector.collect((Object)new Tuple2((Object)result, item.f1));
                }
            }
        }
    }

    private static class CuboidReduceFunction
    extends BaseCuboidReduceFunction {
        private boolean[] needAgg;

        public CuboidReduceFunction(String cubeName, String metaUrl, SerializableConfiguration conf, boolean[] needAgg) {
            super(cubeName, metaUrl, conf);
            this.needAgg = needAgg;
        }

        @Override
        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
        }

        @Override
        public Tuple2<ByteArray, Object[]> reduce(Tuple2<ByteArray, Object[]> input1, Tuple2<ByteArray, Object[]> input2) throws Exception {
            Object[] result = new Object[this.measureNum];
            this.aggregators.aggregate((Object[])input1.f1, (Object[])input2.f1, result, this.needAgg);
            return new Tuple2(input1.f0, (Object)result);
        }
    }

    private static class CuboidReduceGroupFunction
    extends BaseCuboidReduceGroupFunction {
        private boolean[] needAgg;

        public CuboidReduceGroupFunction(String cubeName, String metaUrl, SerializableConfiguration conf, boolean[] needAgg) {
            super(cubeName, metaUrl, conf);
            this.needAgg = needAgg;
        }

        @Override
        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
        }

        @Override
        public void reduce(Iterable<Tuple2<ByteArray, Object[]>> iterable, Collector<Tuple2<ByteArray, Object[]>> collector) throws Exception {
            Object[] result = null;
            ByteArray key = null;
            for (Tuple2<ByteArray, Object[]> item : iterable) {
                key = (ByteArray)item.f0;
                if (result == null) {
                    result = (Object[])item.f1;
                    continue;
                }
                Object[] temp = new Object[this.measureNum];
                this.aggregators.aggregate((Object[])item.f1, result, temp, this.needAgg);
                result = temp;
            }
            collector.collect((Object)new Tuple2(key, result));
        }
    }

    private static class BaseCuboidReduceFunction
    extends RichReduceFunction<Tuple2<ByteArray, Object[]>> {
        protected String cubeName;
        protected String metaUrl;
        protected CubeDesc cubeDesc;
        protected int measureNum;
        protected MeasureAggregators aggregators;
        protected SerializableConfiguration conf;

        public BaseCuboidReduceFunction(String cubeName, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                this.cubeDesc = cubeInstance.getDescriptor();
                this.aggregators = new MeasureAggregators(this.cubeDesc.getMeasures());
                this.measureNum = this.cubeDesc.getMeasures().size();
            }
        }

        public Tuple2<ByteArray, Object[]> reduce(Tuple2<ByteArray, Object[]> input1, Tuple2<ByteArray, Object[]> input2) throws Exception {
            Object[] result = new Object[this.measureNum];
            this.aggregators.aggregate((Object[])input1.f1, (Object[])input2.f1, result);
            return new Tuple2(input1.f0, (Object)result);
        }
    }

    private static class BaseCuboidReduceGroupFunction
    extends RichGroupReduceFunction<Tuple2<ByteArray, Object[]>, Tuple2<ByteArray, Object[]>> {
        protected String cubeName;
        protected String metaUrl;
        protected CubeDesc cubeDesc;
        protected int measureNum;
        protected MeasureAggregators aggregators;
        protected SerializableConfiguration conf;

        public BaseCuboidReduceGroupFunction(String cubeName, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                this.cubeDesc = cubeInstance.getDescriptor();
                this.aggregators = new MeasureAggregators(this.cubeDesc.getMeasures());
                this.measureNum = this.cubeDesc.getMeasures().size();
            }
        }

        public void reduce(Iterable<Tuple2<ByteArray, Object[]>> iterable, Collector<Tuple2<ByteArray, Object[]>> collector) throws Exception {
            Object[] result = null;
            ByteArray key = null;
            for (Tuple2<ByteArray, Object[]> item : iterable) {
                key = (ByteArray)item.f0;
                if (result == null) {
                    result = (Object[])item.f1;
                    continue;
                }
                Object[] temp = new Object[this.measureNum];
                this.aggregators.aggregate((Object[])item.f1, result, temp);
                result = temp;
            }
            collector.collect((Object)new Tuple2(key, result));
        }
    }

    private static class EncodeBaseCuboidMapPartitionFunction
    extends RichMapPartitionFunction<String[], Tuple2<ByteArray, Object[]>> {
        private BaseCuboidBuilder baseCuboidBuilder = null;
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private SerializableConfiguration conf;

        public EncodeBaseCuboidMapPartitionFunction(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                CubeDesc cubeDesc = cubeInstance.getDescriptor();
                CubeSegment cubeSegment = cubeInstance.getSegmentById(this.segmentId);
                CubeJoinedFlatTableEnrich interDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc(cubeSegment), cubeDesc);
                long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
                Cuboid baseCuboid = Cuboid.findForMandatory(cubeDesc, baseCuboidId);
                this.baseCuboidBuilder = new BaseCuboidBuilder(kConfig, cubeDesc, cubeSegment, interDesc, AbstractRowKeyEncoder.createInstance(cubeSegment, baseCuboid), MeasureIngester.create(cubeDesc.getMeasures()), cubeSegment.buildDictionaryMap());
            }
        }

        public void mapPartition(Iterable<String[]> rowArrays, Collector<Tuple2<ByteArray, Object[]>> collector) throws Exception {
            for (String[] rowArray : rowArrays) {
                this.baseCuboidBuilder.resetAggrs();
                byte[] rowKey = this.baseCuboidBuilder.buildKey(rowArray);
                Object[] result = this.baseCuboidBuilder.buildValueObjects(rowArray);
                collector.collect((Object)new Tuple2((Object)new ByteArray(rowKey), (Object)result));
            }
        }
    }

    private static class EncodeBaseCuboidMapFunction
    extends RichMapFunction<String[], Tuple2<ByteArray, Object[]>> {
        private BaseCuboidBuilder baseCuboidBuilder = null;
        private String cubeName;
        private String segmentId;
        private String metaUrl;
        private SerializableConfiguration conf;

        public EncodeBaseCuboidMapFunction(String cubeName, String segmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.segmentId = segmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        public void open(Configuration parameters) throws Exception {
            KylinConfig kConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kConfig);){
                CubeInstance cubeInstance = CubeManager.getInstance(kConfig).getCube(this.cubeName);
                CubeDesc cubeDesc = cubeInstance.getDescriptor();
                CubeSegment cubeSegment = cubeInstance.getSegmentById(this.segmentId);
                CubeJoinedFlatTableEnrich interDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc(cubeSegment), cubeDesc);
                long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
                Cuboid baseCuboid = Cuboid.findForMandatory(cubeDesc, baseCuboidId);
                this.baseCuboidBuilder = new BaseCuboidBuilder(kConfig, cubeDesc, cubeSegment, interDesc, AbstractRowKeyEncoder.createInstance(cubeSegment, baseCuboid), MeasureIngester.create(cubeDesc.getMeasures()), cubeSegment.buildDictionaryMap());
            }
        }

        public Tuple2<ByteArray, Object[]> map(String[] rowArray) throws Exception {
            this.baseCuboidBuilder.resetAggrs();
            byte[] rowKey = this.baseCuboidBuilder.buildKey(rowArray);
            Object[] result = this.baseCuboidBuilder.buildValueObjects(rowArray);
            return new Tuple2((Object)new ByteArray(rowKey), (Object)result);
        }
    }
}

