/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidUtil;
import org.apache.kylin.cube.kv.RowKeyDecoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hasher;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateStatsFromBaseCuboidMapper
extends KylinMapper<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(CalculateStatsFromBaseCuboidMapper.class);
    protected int nRowKey;
    protected long baseCuboidId;
    private int samplingPercentage;
    private int rowCount = 0;
    private long[] rowHashCodesLong = null;
    private boolean isUsePutRowKeyToHllNewAlgorithm;
    private HLLCounter[] allCuboidsHLL = null;
    private Long[] cuboidIds;
    private Integer[][] allCuboidsBitSet = null;
    private HashFunction hf = null;
    RowKeyDecoder rowKeyDecoder;
    protected Text outputKey = new Text();
    protected Text outputValue = new Text();

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        HadoopUtil.setCurrentConfiguration(conf);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        String cubeName = conf.get("cube.name");
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        CubeDesc cubeDesc = cube.getDescriptor();
        CubeSegment cubeSegment = cube.getSegmentById(conf.get("cube.segment.id"));
        this.baseCuboidId = cube.getCuboidScheduler().getBaseCuboidId();
        this.nRowKey = cubeDesc.getRowkey().getRowKeyColumns().length;
        String cuboidModeName = conf.get("cuboid.mode");
        Set<Long> cuboidIdSet = cube.getCuboidsByMode(cuboidModeName);
        this.cuboidIds = cuboidIdSet.toArray(new Long[cuboidIdSet.size()]);
        this.allCuboidsBitSet = CuboidUtil.getCuboidBitSet(this.cuboidIds, this.nRowKey);
        this.samplingPercentage = Integer.parseInt(context.getConfiguration().get("statistics.sampling.percent"));
        this.allCuboidsHLL = new HLLCounter[this.cuboidIds.length];
        for (int i = 0; i < this.cuboidIds.length; ++i) {
            this.allCuboidsHLL[i] = new HLLCounter(cubeDesc.getConfig().getCubeStatsHLLPrecision());
        }
        if (KylinVersion.isBefore200(cubeDesc.getVersion())) {
            this.isUsePutRowKeyToHllNewAlgorithm = false;
            this.hf = Hashing.murmur3_32();
            logger.info("Found KylinVersion : {}. Use old algorithm for cuboid sampling.", (Object)cubeDesc.getVersion());
        } else {
            this.isUsePutRowKeyToHllNewAlgorithm = true;
            this.rowHashCodesLong = new long[this.nRowKey];
            this.hf = Hashing.murmur3_128();
            logger.info("Found KylinVersion : {}. Use new algorithm for cuboid sampling. About the details of the new algorithm, please refer to KYLIN-2518", (Object)cubeDesc.getVersion());
        }
        this.rowKeyDecoder = new RowKeyDecoder(cubeSegment);
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws InterruptedException, IOException {
        long cuboidID = this.rowKeyDecoder.decode(key.getBytes());
        if (cuboidID != this.baseCuboidId) {
            return;
        }
        List<String> keyValues = this.rowKeyDecoder.getValues();
        if (this.rowCount < this.samplingPercentage) {
            Preconditions.checkArgument(this.nRowKey == keyValues.size());
            String[] row = keyValues.toArray(new String[keyValues.size()]);
            if (this.isUsePutRowKeyToHllNewAlgorithm) {
                this.putRowKeyToHLLNew(row);
            } else {
                this.putRowKeyToHLLOld(row);
            }
        }
        if (++this.rowCount == 100) {
            this.rowCount = 0;
        }
    }

    public void putRowKeyToHLLOld(String[] row) {
        Hasher hc;
        int i;
        byte[][] rowHashCodes = new byte[this.nRowKey][];
        for (i = 0; i < this.nRowKey; ++i) {
            hc = this.hf.newHasher();
            String colValue = row[i];
            rowHashCodes[i] = colValue != null ? hc.putUnencodedChars(colValue).hash().asBytes() : hc.putInt(0).hash().asBytes();
        }
        for (i = 0; i < this.cuboidIds.length; ++i) {
            hc = this.hf.newHasher();
            for (int position = 0; position < this.allCuboidsBitSet[i].length; ++position) {
                hc.putBytes(rowHashCodes[this.allCuboidsBitSet[i][position]]);
            }
            this.allCuboidsHLL[i].add(hc.hash().asBytes());
        }
    }

    private void putRowKeyToHLLNew(String[] row) {
        int i;
        for (i = 0; i < this.nRowKey; ++i) {
            Hasher hc = this.hf.newHasher();
            String colValue = row[i];
            if (colValue == null) {
                colValue = "0";
            }
            byte[] bytes = hc.putUnencodedChars(colValue).hash().asBytes();
            this.rowHashCodesLong[i] = Bytes.toLong(bytes) + (long)i;
        }
        int n = this.allCuboidsBitSet.length;
        for (i = 0; i < n; ++i) {
            long value = 0L;
            for (int position = 0; position < this.allCuboidsBitSet[i].length; ++position) {
                value += this.rowHashCodesLong[this.allCuboidsBitSet[i][position]];
            }
            this.allCuboidsHLL[i].addHashDirectly(value);
        }
    }

    @Override
    protected void doCleanup(Mapper.Context context) throws IOException, InterruptedException {
        ByteBuffer hllBuf = ByteBuffer.allocate(0x100000);
        for (int i = 0; i < this.cuboidIds.length; ++i) {
            HLLCounter hll = this.allCuboidsHLL[i];
            this.outputKey.set(Bytes.toBytes(this.cuboidIds[i]));
            hllBuf.clear();
            hll.writeRegisters(hllBuf);
            this.outputValue.set(hllBuf.array(), 0, hllBuf.position());
            context.write((Object)this.outputKey, (Object)this.outputValue);
        }
    }
}

