/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.SegmentReEncoder;

public class MergeCuboidMapper
extends KylinMapper<Text, Text, Text, Text> {
    private SegmentReEncoder reEncoder;
    private Pair<Text, Text> newPair;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException, InterruptedException {
        super.bindCurrentConfiguration(context.getConfiguration());
        String cubeName = context.getConfiguration().get("cube.name");
        String segmentID = context.getConfiguration().get("cube.segment.id");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeManager cubeManager = CubeManager.getInstance(config);
        CubeInstance cube = cubeManager.getCube(cubeName);
        CubeDesc cubeDesc = cube.getDescriptor();
        CubeSegment mergedCubeSegment = cube.getSegmentById(segmentID);
        FileSplit fileSplit = (FileSplit)context.getInputSplit();
        IMROutput2.IMRMergeOutputFormat outputFormat = MRUtil.getBatchMergeOutputSide2(mergedCubeSegment).getOutputFormat();
        CubeSegment sourceCubeSegment = outputFormat.findSourceSegment(fileSplit, cube);
        this.reEncoder = new SegmentReEncoder(cubeDesc, sourceCubeSegment, mergedCubeSegment, config);
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.newPair = this.reEncoder.reEncode(key, value);
        context.write((Object)this.newPair.getFirst(), (Object)this.newPair.getSecond());
    }
}

