/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkFunction {
    protected static final Logger logger = LoggerFactory.getLogger(SparkFunction.class);

    public static abstract class VoidFunctionBase<T>
    extends FunctionBase
    implements VoidFunction<T> {
        protected abstract void doCall(T var1) throws Exception;

        public void call(T t) throws Exception {
            this.init();
            this.doCall(t);
        }
    }

    public static abstract class PairFlatMapFunctionBase<T, K, V>
    extends FunctionBase
    implements PairFlatMapFunction<T, K, V> {
        protected abstract Iterator<Tuple2<K, V>> doCall(T var1) throws Exception;

        public Iterator<Tuple2<K, V>> call(T t) throws Exception {
            this.init();
            return this.doCall(t);
        }
    }

    public static abstract class Function2Base<T1, T2, R>
    extends FunctionBase
    implements Function2<T1, T2, R> {
        protected abstract R doCall(T1 var1, T2 var2) throws Exception;

        public R call(T1 v1, T2 v2) throws Exception {
            this.init();
            return this.doCall(v1, v2);
        }
    }

    public static abstract class PairFunctionBase<T, K, V>
    extends FunctionBase
    implements PairFunction<T, K, V> {
        protected abstract Tuple2<K, V> doCall(T var1) throws Exception;

        public Tuple2<K, V> call(T t) throws Exception {
            this.init();
            return this.doCall(t);
        }
    }

    private static abstract class FunctionBase
    implements Serializable {
        private volatile transient boolean initialized = false;
        private transient int recordCounter;

        private FunctionBase() {
        }

        protected abstract void doInit();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected void init() {
            if (!this.initialized) {
                Class<SparkFunction> clazz = SparkFunction.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkFunction.class
                if (!this.initialized) {
                    logger.info("Start to do init for {}", (Object)this);
                    this.doInit();
                    this.initialized = true;
                    this.recordCounter = 0;
                }
                // MONITOREXIT : clazz
            }
            if (this.recordCounter++ % SparkUtil.getNormalRecordLogThreshold() != 0) return;
            logger.info("Accepting record with ordinal: " + this.recordCounter);
            logger.info("Do call, available memory: {}m", (Object)MemoryBudgetController.getSystemAvailMB());
        }
    }
}

