/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kylin.common.util.ByteBufferOutputStream;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RoaringBitmapCounter
implements BitmapCounter,
Serializable {
    private ImmutableRoaringBitmap bitmap;
    private Long counter;

    RoaringBitmapCounter() {
        this.bitmap = new MutableRoaringBitmap();
    }

    RoaringBitmapCounter(ImmutableRoaringBitmap bitmap) {
        this.bitmap = bitmap;
    }

    RoaringBitmapCounter(long counter) {
        this.counter = counter;
    }

    private MutableRoaringBitmap getMutableBitmap() {
        if (this.bitmap instanceof MutableRoaringBitmap) {
            return (MutableRoaringBitmap)this.bitmap;
        }
        MutableRoaringBitmap result = this.bitmap.toMutableRoaringBitmap();
        this.bitmap = result;
        return result;
    }

    @Override
    public void add(int value) {
        this.getMutableBitmap().add(value);
    }

    @Override
    public void orWith(BitmapCounter another) {
        if (another instanceof RoaringBitmapCounter) {
            RoaringBitmapCounter input = (RoaringBitmapCounter)another;
            this.getMutableBitmap().or(input.bitmap);
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + another.getClass().getCanonicalName());
    }

    @Override
    public void andWith(BitmapCounter another) {
        if (another instanceof RoaringBitmapCounter) {
            RoaringBitmapCounter input = (RoaringBitmapCounter)another;
            this.getMutableBitmap().and(input.bitmap);
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + another.getClass().getCanonicalName());
    }

    @Override
    public void clear() {
        this.bitmap = new MutableRoaringBitmap();
    }

    @Override
    public long getCount() {
        if (this.counter != null) {
            return this.counter;
        }
        return this.bitmap.getCardinality();
    }

    @Override
    public int getMemBytes() {
        return this.bitmap.getSizeInBytes();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.bitmap.iterator();
    }

    @Override
    public void write(ByteBuffer out) throws IOException {
        if (this.bitmap instanceof MutableRoaringBitmap) {
            this.getMutableBitmap().runOptimize();
        }
        if (out.remaining() < this.bitmap.serializedSizeInBytes()) {
            throw new BufferOverflowException();
        }
        try (DataOutputStream dos = new DataOutputStream(new ByteBufferOutputStream(out));){
            this.bitmap.serialize((DataOutput)dos);
        }
    }

    @Override
    public void readFields(ByteBuffer in) throws IOException {
        int size = this.peekLength(in);
        byte[] dst = new byte[size];
        in.get(dst);
        this.bitmap = new ImmutableRoaringBitmap(ByteBuffer.wrap(dst));
    }

    @Override
    public int peekLength(ByteBuffer in) {
        ImmutableRoaringBitmap bitmap = new ImmutableRoaringBitmap(in);
        return bitmap.serializedSizeInBytes();
    }

    public boolean equals(Object obj) {
        return obj instanceof RoaringBitmapCounter && this.bitmap.equals((Object)((RoaringBitmapCounter)obj).bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public String toString() {
        return "RoaringBitmapCounter[" + this.getCount() + "]";
    }
}

