/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.service.AclService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.springframework.security.acls.AclPermissionEvaluator;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;

public class KylinAclPermissionEvaluator
extends AclPermissionEvaluator {
    private PermissionFactory kylinPermissionFactory;

    public KylinAclPermissionEvaluator(AclService aclService, PermissionFactory permissionFactory) {
        super(aclService);
        super.setPermissionFactory(permissionFactory);
        this.kylinPermissionFactory = permissionFactory;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        ExternalAclProvider eap = ExternalAclProvider.getInstance();
        if (eap == null) {
            return super.hasPermission(authentication, targetDomainObject, permission);
        }
        if (targetDomainObject == null) {
            return false;
        }
        AclEntity e = (AclEntity)targetDomainObject;
        return this.checkExternalPermission(eap, authentication, e.getClass().getSimpleName(), e.getId(), permission);
    }

    private boolean checkExternalPermission(ExternalAclProvider eap, Authentication authentication, String entityType, String entityUuid, Object permission) {
        String currentUser = authentication.getName();
        List<String> authorities = AclPermissionUtil.transformAuthorities(authentication.getAuthorities());
        List<Permission> kylinPermissions = this.resolveKylinPermission(permission);
        for (Permission p : kylinPermissions) {
            if (!eap.checkPermission(currentUser, authorities, entityType, entityUuid, p)) continue;
            return true;
        }
        return false;
    }

    private List<Permission> resolveKylinPermission(Object permission) {
        if (permission instanceof Integer) {
            return Arrays.asList(this.kylinPermissionFactory.buildFromMask((Integer)permission));
        }
        if (permission instanceof Permission) {
            return Arrays.asList((Permission)permission);
        }
        if (permission instanceof Permission[]) {
            return Arrays.asList((Permission[])permission);
        }
        if (permission instanceof String) {
            Permission p;
            String permString = (String)permission;
            try {
                p = this.kylinPermissionFactory.buildFromName(permString);
            }
            catch (IllegalArgumentException notfound) {
                p = this.kylinPermissionFactory.buildFromName(permString.toUpperCase(Locale.ROOT));
            }
            if (p != null) {
                return Arrays.asList(p);
            }
        }
        throw new IllegalArgumentException("Unsupported permission: " + permission);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        ExternalAclProvider eap = ExternalAclProvider.getInstance();
        if (eap == null) {
            return super.hasPermission(authentication, targetId, targetType, permission);
        }
        return this.checkExternalPermission(eap, authentication, targetType, targetId.toString(), permission);
    }
}

