/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.source.hive.DBConnConf;
import org.apache.kylin.source.jdbc.SqlUtil;
import org.apache.kylin.source.jdbc.metadata.DefaultJdbcMetadata;

public class PostgresqlJdbcMetadata
extends DefaultJdbcMetadata {
    public PostgresqlJdbcMetadata(DBConnConf dbConnConf) {
        super(dbConnConf);
    }

    @Override
    public List<String> listDatabases() throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Connection con = SqlUtil.getConnection(this.dbconf);){
            ret.add(con.getSchema());
        }
        return ret;
    }

    @Override
    public List<String> listTables(String catalog) throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        String[] tableTypes = new String[]{"TABLE"};
        try (Connection con = SqlUtil.getConnection(this.dbconf);
             ResultSet res = con.getMetaData().getTables(catalog, null, null, tableTypes);){
            while (res.next()) {
                String table = res.getString("TABLE_NAME");
                ret.add(table);
            }
        }
        return ret;
    }

    @Override
    public ResultSet listColumns(DatabaseMetaData dbmd, String catalog, String table) throws SQLException {
        return dbmd.getColumns(catalog, null, table, null);
    }

    @Override
    public ResultSet getTable(DatabaseMetaData dbmd, String catalog, String table) throws SQLException {
        return dbmd.getTables(catalog, null, table, null);
    }
}

