/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.io.IOException;
import java.util.Iterator;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.Iterators;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.gtrecord.IPartitionStreamer;
import org.apache.kylin.storage.gtrecord.PartitionResultIterator;
import org.apache.kylin.storage.gtrecord.SortMergedPartitionResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageResponseGTScatter
implements IGTScanner {
    private static final Logger logger = LoggerFactory.getLogger(StorageResponseGTScatter.class);
    private final GTInfo info;
    private IPartitionStreamer partitionStreamer;
    private final Iterator<byte[]> blocks;
    private final ImmutableBitSet columns;
    private final ImmutableBitSet groupByDims;
    private final boolean needSorted;

    public StorageResponseGTScatter(GTScanRequest scanRequest, IPartitionStreamer partitionStreamer, StorageContext context) {
        this.info = scanRequest.getInfo();
        this.partitionStreamer = partitionStreamer;
        this.blocks = partitionStreamer.asByteArrayIterator();
        this.columns = scanRequest.getColumns();
        this.groupByDims = scanRequest.getAggrGroupBy();
        this.needSorted = context.getFinalPushDownLimit() != Integer.MAX_VALUE || context.isStreamAggregateEnabled();
    }

    @Override
    public GTInfo getInfo() {
        return this.info;
    }

    @Override
    public void close() throws IOException {
        this.partitionStreamer.close();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        Iterator<PartitionResultIterator> iterators = Iterators.transform(this.blocks, new Function<byte[], PartitionResultIterator>(){

            @Override
            public PartitionResultIterator apply(byte[] input) {
                return new PartitionResultIterator(input, StorageResponseGTScatter.this.info, StorageResponseGTScatter.this.columns);
            }
        });
        if (!this.needSorted) {
            logger.debug("Using Iterators.concat to pipeline partition results");
            return Iterators.concat(iterators);
        }
        return new SortMergedPartitionResultIterator(iterators, this.info, GTRecord.getComparator(this.groupByDims));
    }
}

