/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hbase.steps.KeyValueCreator;
import org.apache.kylin.storage.hbase.steps.RowKeyWritable;

public class CubeHFileMapper
extends KylinMapper<Text, Text, RowKeyWritable, KeyValue> {
    String cubeName;
    CubeDesc cubeDesc;
    MeasureCodec inputCodec;
    Object[] inputMeasures;
    List<KeyValueCreator> keyValueCreators;
    private RowKeyWritable rowKeyWritable = new RowKeyWritable();

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeManager cubeMgr = CubeManager.getInstance(config);
        this.cubeDesc = cubeMgr.getCube(this.cubeName).getDescriptor();
        this.inputCodec = new MeasureCodec(this.cubeDesc.getMeasures());
        this.inputMeasures = new Object[this.cubeDesc.getMeasures().size()];
        this.keyValueCreators = Lists.newArrayList();
        for (HBaseColumnFamilyDesc cfDesc : this.cubeDesc.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc colDesc : cfDesc.getColumns()) {
                this.keyValueCreators.add(new KeyValueCreator(this.cubeDesc, colDesc));
            }
        }
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        int n = this.keyValueCreators.size();
        if (n == 1 && this.keyValueCreators.get((int)0).isFullCopy) {
            KeyValue outputValue = this.keyValueCreators.get(0).create(key, value.getBytes(), 0, value.getLength());
            this.rowKeyWritable.set(outputValue.createKeyOnly(false).getKey());
            context.write((Object)this.rowKeyWritable, (Object)outputValue);
        } else {
            this.inputCodec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), this.inputMeasures);
            for (int i = 0; i < n; ++i) {
                KeyValue outputValue = this.keyValueCreators.get(i).create(key, this.inputMeasures);
                this.rowKeyWritable.set(outputValue.createKeyOnly(false).getKey());
                context.write((Object)this.rowKeyWritable, (Object)outputValue);
            }
        }
    }
}

