/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.compress.Compression;
import org.apache.kylin.stream.core.storage.columnar.compress.FSInputLZ4CompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.FSInputNoCompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.FSInputRLECompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.LZ4CompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.LZ4CompressedColumnWriter;
import org.apache.kylin.stream.core.storage.columnar.compress.NoCompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.NoCompressedColumnWriter;
import org.apache.kylin.stream.core.storage.columnar.compress.RunLengthCompressedColumnReader;
import org.apache.kylin.stream.core.storage.columnar.compress.RunLengthCompressedColumnWriter;

public class ColumnarStoreDimDesc {
    private int fixLen;
    private Compression compression;

    public static ColumnarStoreDimDesc getDefaultCStoreDimDesc(CubeDesc cubeDesc, String dimName, DimensionEncoding encoding) {
        if (TimeDerivedColumnType.isTimeDerivedColumn(dimName)) {
            return new ColumnarStoreDimDesc(encoding.getLengthOfEncoding(), Compression.RUN_LENGTH);
        }
        if (cubeDesc.getRowkey().getRowKeyColumns()[0].getColumn().equals(dimName)) {
            return new ColumnarStoreDimDesc(encoding.getLengthOfEncoding(), Compression.RUN_LENGTH);
        }
        return new ColumnarStoreDimDesc(encoding.getLengthOfEncoding(), Compression.LZ4);
    }

    public ColumnarStoreDimDesc(int fixLen, Compression compression) {
        this.fixLen = fixLen;
        this.compression = compression;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ColumnDataWriter getDimWriter(OutputStream output, int rowCnt) {
        if (this.compression == Compression.LZ4) {
            return new LZ4CompressedColumnWriter(this.fixLen, rowCnt, 65536, output);
        }
        if (this.compression == Compression.RUN_LENGTH) {
            return new RunLengthCompressedColumnWriter(this.fixLen, rowCnt, 65536, output);
        }
        return new NoCompressedColumnWriter(output);
    }

    public ColumnDataReader getDimReader(ByteBuffer dataBuffer, int columnDataStartOffset, int columnDataLength, int rowCount) {
        if (this.compression == Compression.LZ4) {
            return new LZ4CompressedColumnReader(dataBuffer, columnDataStartOffset, columnDataLength, rowCount);
        }
        if (this.compression == Compression.RUN_LENGTH) {
            return new RunLengthCompressedColumnReader(dataBuffer, columnDataStartOffset, columnDataLength, rowCount);
        }
        return new NoCompressedColumnReader(dataBuffer, columnDataStartOffset, columnDataLength / rowCount, rowCount);
    }

    public ColumnDataReader getDimReaderFromFSInput(FileSystem fs, Path file, int columnDataStartOffset, int columnDataLength, int rowCount) throws IOException {
        if (this.compression == Compression.LZ4) {
            return new FSInputLZ4CompressedColumnReader(fs, file, columnDataStartOffset, columnDataLength, rowCount);
        }
        if (this.compression == Compression.RUN_LENGTH) {
            return new FSInputRLECompressedColumnReader(fs, file, columnDataStartOffset, columnDataLength, rowCount);
        }
        return new FSInputNoCompressedColumnReader(fs, file, columnDataStartOffset, columnDataLength / rowCount, rowCount);
    }
}

