/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.GeneralColumnDataReader;

public class LZ4CompressedColumnReader
implements ColumnDataReader {
    private int rowCount;
    private int valLen;
    private int numValInBlock;
    private int maxBufferLength;
    private int currBlockNum;
    private LZ4SafeDecompressor deCompressor;
    private ByteBuffer decompressedBuffer;
    private GeneralColumnDataReader blockDataReader;

    public LZ4CompressedColumnReader(ByteBuffer dataBuffer, int columnDataStartOffset, int columnDataLength, int rowCount) {
        this.rowCount = rowCount;
        int footStartOffset = columnDataStartOffset + columnDataLength - 8;
        dataBuffer.position(footStartOffset);
        this.numValInBlock = dataBuffer.getInt();
        this.valLen = dataBuffer.getInt();
        this.blockDataReader = new GeneralColumnDataReader(dataBuffer, columnDataStartOffset, columnDataLength - 8);
        this.currBlockNum = -1;
        this.deCompressor = LZ4Factory.fastestInstance().safeDecompressor();
        this.maxBufferLength = this.numValInBlock * this.valLen;
        this.decompressedBuffer = ByteBuffer.allocate(this.maxBufferLength);
    }

    private void loadBuffer(int targetBlockNum) {
        ByteBuffer compressedBuffer = this.blockDataReader.get(targetBlockNum);
        int length = compressedBuffer.limit() - compressedBuffer.position();
        this.deCompressor.decompress(compressedBuffer, compressedBuffer.position(), length, this.decompressedBuffer, 0, this.maxBufferLength);
        this.decompressedBuffer.position(0);
        this.currBlockNum = targetBlockNum;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new LZ4CompressedColumnDataItr();
    }

    @Override
    public byte[] read(int rowNum) {
        int targetBlockNum = rowNum / this.numValInBlock;
        if (targetBlockNum != this.currBlockNum) {
            this.loadBuffer(targetBlockNum);
        }
        this.decompressedBuffer.position(rowNum % this.numValInBlock * this.valLen);
        byte[] readBuffer = new byte[this.valLen];
        this.decompressedBuffer.get(readBuffer);
        return readBuffer;
    }

    @Override
    public void close() throws IOException {
    }

    private class LZ4CompressedColumnDataItr
    implements Iterator<byte[]> {
        private int readRowCount = 0;

        @Override
        public boolean hasNext() {
            return this.readRowCount < LZ4CompressedColumnReader.this.rowCount;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (LZ4CompressedColumnReader.this.currBlockNum == -1 || !LZ4CompressedColumnReader.this.decompressedBuffer.hasRemaining()) {
                this.loadNextBuffer();
            }
            byte[] readBuffer = new byte[LZ4CompressedColumnReader.this.valLen];
            LZ4CompressedColumnReader.this.decompressedBuffer.get(readBuffer);
            ++this.readRowCount;
            return readBuffer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported");
        }

        private void loadNextBuffer() {
            LZ4CompressedColumnReader.this.loadBuffer(LZ4CompressedColumnReader.this.currBlockNum + 1);
        }
    }
}

