/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.invertindex;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.kylin.stream.core.storage.columnar.invertindex.ColInvertIndexWriter;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class FixLenColInvertIndexWriter
extends ColInvertIndexWriter {
    private int valueLenInBytes;
    private int rows;
    private Map<byte[], MutableRoaringBitmap> valueBitmaps = new TreeMap<byte[], MutableRoaringBitmap>((Comparator<byte[]>)new Bytes.ByteArrayComparator());

    public FixLenColInvertIndexWriter(String columnName, int valueLenInBytes) {
        super(columnName);
        this.valueLenInBytes = valueLenInBytes;
    }

    @Override
    public void addValue(byte[] value) {
        if (value.length != this.valueLenInBytes) {
            throw new IllegalArgumentException("the value:" + Bytes.toHex((byte[])value) + " is not valid.");
        }
        MutableRoaringBitmap bitmap = this.valueBitmaps.get(value);
        if (bitmap == null) {
            bitmap = new MutableRoaringBitmap();
            this.valueBitmaps.put(value, bitmap);
        }
        bitmap.add(++this.rows);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        int cardinality = this.valueBitmaps.size();
        int footLen = 12;
        int dictAndFootLen = cardinality * (this.valueLenInBytes + 4) + footLen;
        DataOutputStream bitmapOut = new DataOutputStream(out);
        ByteBuffer dictBuffer = ByteBuffer.allocate(dictAndFootLen);
        int offset = 0;
        for (Map.Entry<byte[], MutableRoaringBitmap> bitmapEntry : this.valueBitmaps.entrySet()) {
            byte[] colValue = bitmapEntry.getKey();
            MutableRoaringBitmap bitmap = bitmapEntry.getValue();
            bitmap.runOptimize();
            int bitmapSize = bitmap.serializedSizeInBytes();
            bitmap.serialize((DataOutput)bitmapOut);
            dictBuffer.put(colValue);
            dictBuffer.putInt(offset);
            offset += bitmapSize;
        }
        dictBuffer.putInt(cardinality);
        dictBuffer.putInt(this.valueLenInBytes);
        dictBuffer.putInt(1);
        out.write(dictBuffer.array(), 0, dictBuffer.position());
        out.flush();
    }
}

