/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectStatusEnum;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class ProjectCreator {
    private static final String SYSTEM_PROJECT_DESC = "This project is kylin's system project for kylin metrics";

    public static ProjectInstance generateKylinProjectInstance(String owner, List<TableDesc> kylinTables, List<DataModelDesc> kylinModels, List<CubeDesc> kylinCubeDescs) {
        ProjectInstance projectInstance = new ProjectInstance();
        projectInstance.setName("KYLIN_SYSTEM");
        projectInstance.setOwner(owner);
        projectInstance.setDescription(SYSTEM_PROJECT_DESC);
        projectInstance.setStatus(ProjectStatusEnum.ENABLED);
        projectInstance.setCreateTimeUTC(System.currentTimeMillis());
        projectInstance.updateRandomUuid();
        if (kylinTables != null) {
            projectInstance.setTables(Sets.newHashSet(Lists.transform(kylinTables, new Function<TableDesc, String>(){

                @Override
                @Nullable
                public String apply(@Nullable TableDesc tableDesc) {
                    if (tableDesc != null) {
                        return tableDesc.getIdentity();
                    }
                    return null;
                }
            })));
        } else {
            projectInstance.setTables(Sets.newHashSet());
        }
        if (kylinModels != null) {
            projectInstance.setModels(Lists.transform(kylinModels, new Function<DataModelDesc, String>(){

                @Override
                @Nullable
                public String apply(@Nullable DataModelDesc modelDesc) {
                    if (modelDesc != null) {
                        return modelDesc.getName();
                    }
                    return null;
                }
            }));
        } else {
            projectInstance.setModels(Lists.newArrayList());
        }
        if (kylinCubeDescs != null) {
            projectInstance.setRealizationEntries(Lists.transform(kylinCubeDescs, new Function<CubeDesc, RealizationEntry>(){

                @Override
                @Nullable
                public RealizationEntry apply(@Nullable CubeDesc cubeDesc) {
                    if (cubeDesc != null) {
                        RealizationEntry entry = new RealizationEntry();
                        entry.setRealization(cubeDesc.getName());
                        entry.setType(RealizationType.CUBE);
                        return entry;
                    }
                    return null;
                }
            }));
        } else {
            projectInstance.setRealizationEntries(Lists.newArrayList());
        }
        return projectInstance;
    }
}

