/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.query;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(QueryGenerator.class);

    public static List<String> generateQueryList(CubeDesc cubeDesc, int nOfQuery, int maxNumOfDimension) {
        int nDimension = cubeDesc.getDimensions().size();
        if (maxNumOfDimension > nDimension) {
            maxNumOfDimension = nDimension;
        } else if (maxNumOfDimension < 1) {
            maxNumOfDimension = 1;
        }
        int queryMaxSize = QueryGenerator.getQueryMaxSize(maxNumOfDimension, nDimension);
        queryMaxSize = (int)Math.ceil((double)queryMaxSize * 0.5);
        if (nOfQuery > queryMaxSize) {
            nOfQuery = queryMaxSize;
        }
        logger.info("Will generate {} queries", (Object)nOfQuery);
        ArrayList sqlList = Lists.newArrayListWithExpectedSize((int)nOfQuery);
        HashSet selected = Sets.newHashSetWithExpectedSize((int)nOfQuery);
        while (sqlList.size() < nOfQuery) {
            sqlList.add(QueryGenerator.generateQuery(cubeDesc, selected, maxNumOfDimension));
        }
        return sqlList;
    }

    public static int getQueryMaxSize(int m, int nDimension) {
        int i;
        int a = nDimension - m >= m ? nDimension - m : m;
        int b = nDimension - a;
        BigInteger result = new BigInteger(String.valueOf(1));
        for (i = a + 1; i <= nDimension; ++i) {
            result = result.multiply(new BigInteger(String.valueOf(i)));
        }
        for (i = 2; i <= b; ++i) {
            result = result.divide(new BigInteger(String.valueOf(i)));
        }
        return result.intValue();
    }

    public static String generateQuery(CubeDesc cubeDesc, Set<BitSet> selected, int maxNumOfDimension) {
        CubeJoinedFlatTableDesc flatDesc = new CubeJoinedFlatTableDesc(cubeDesc);
        String dimensionStatement = QueryGenerator.createDimensionStatement(cubeDesc.getDimensions(), selected, maxNumOfDimension);
        String measureStatement = QueryGenerator.createMeasureStatement(cubeDesc.getMeasures());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT\n");
        sql.append(dimensionStatement);
        sql.append(measureStatement);
        StringBuilder joinPart = new StringBuilder();
        JoinedFlatTable.appendJoinStatement(flatDesc, joinPart, false, null);
        sql.append(joinPart.toString().replaceAll("DEFAULT\\.", ""));
        sql.append("GROUP BY\n");
        sql.append(dimensionStatement);
        String ret = sql.toString();
        ret = ret.replaceAll("`", "\"");
        return ret;
    }

    public static String createMeasureStatement(List<MeasureDesc> measureList) {
        StringBuilder sql = new StringBuilder();
        for (MeasureDesc measureDesc : measureList) {
            FunctionDesc functionDesc = measureDesc.getFunction();
            if (functionDesc.isSum() || functionDesc.isMax() || functionDesc.isMin()) {
                sql.append("," + functionDesc.getExpression() + "(" + functionDesc.getParameter().getValue() + ")\n");
                break;
            }
            if (!functionDesc.isCountDistinct()) continue;
            sql.append(",COUNT(DISTINCT " + functionDesc.getParameter().getValue() + ")\n");
            break;
        }
        return sql.toString();
    }

    public static String createDimensionStatement(List<DimensionDesc> dimensionList, Set<BitSet> selected, int maxNumOfDimension) {
        BitSet bitSet;
        StringBuilder sql = new StringBuilder();
        while ((bitSet = QueryGenerator.generateIfSelectList(dimensionList.size(), Math.ceil((double)maxNumOfDimension * Math.random()) / (double)dimensionList.size())).cardinality() > maxNumOfDimension || bitSet.cardinality() <= 0 || selected.contains(bitSet)) {
        }
        selected.add(bitSet);
        ArrayList selectedCols = Lists.newArrayList();
        int j = 0;
        for (int i = 0; i < dimensionList.size(); ++i) {
            if (!bitSet.get(i)) continue;
            DimensionDesc dimensionDesc = dimensionList.get(i);
            String tableName = QueryGenerator.getTableName(dimensionDesc.getTable());
            String columnName = dimensionDesc.getColumn();
            if (Strings.isNullOrEmpty((String)columnName) || columnName.equals("{FK}")) {
                BitSet subBitSet;
                String[] derivedCols = dimensionDesc.getDerived();
                while ((subBitSet = QueryGenerator.generateIfSelectList(derivedCols.length, 0.5)).cardinality() <= 0) {
                }
                for (int k = 0; k < derivedCols.length; ++k) {
                    if (!subBitSet.get(k)) continue;
                    if (j > 0) {
                        sql.append(",");
                    }
                    sql.append(tableName + ".\"" + derivedCols[k] + "\"\n");
                    selectedCols.add(derivedCols[k]);
                    ++j;
                }
                continue;
            }
            if (j > 0) {
                sql.append(",");
            }
            sql.append(tableName + ".\"" + columnName + "\"\n");
            selectedCols.add(columnName);
            ++j;
        }
        return sql.toString();
    }

    public static BitSet generateIfSelectList(int n, double threshold) {
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (!(Math.random() < threshold)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public static String getTableName(String name) {
        int lastIndexOfDot = name.lastIndexOf(".");
        if (lastIndexOfDot >= 0) {
            name = name.substring(lastIndexOfDot + 1);
        }
        return name;
    }
}

