/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public class RelMdPredicates
implements MetadataHandler<BuiltInMetadata.Predicates> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.PREDICATES.method, new RelMdPredicates());
    private static final List<RexNode> EMPTY_LIST = ImmutableList.of();

    @Override
    public MetadataDef<BuiltInMetadata.Predicates> getDef() {
        return BuiltInMetadata.Predicates.DEF;
    }

    public RelOptPredicateList getPredicates(RelNode rel, RelMetadataQuery mq) {
        return RelOptPredicateList.EMPTY;
    }

    public RelOptPredicateList getPredicates(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.getPulledUpPredicates(rel.getCurrentRel());
    }

    public RelOptPredicateList getPredicates(TableScan table, RelMetadataQuery mq) {
        return RelOptPredicateList.EMPTY;
    }

    public RelOptPredicateList getPredicates(Project project, RelMetadataQuery mq) {
        RelNode input = project.getInput();
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelOptPredicateList inputInfo = mq.getPulledUpPredicates(input);
        ArrayList<RexNode> projectPullUpPredicates = new ArrayList<RexNode>();
        ImmutableBitSet.Builder columnsMappedBuilder = ImmutableBitSet.builder();
        Mapping m = Mappings.create(MappingType.PARTIAL_FUNCTION, input.getRowType().getFieldCount(), project.getRowType().getFieldCount());
        for (Ord<RexNode> o : Ord.zip(project.getProjects())) {
            if (!(o.e instanceof RexInputRef)) continue;
            int sIdx = ((RexInputRef)o.e).getIndex();
            m.set(sIdx, o.i);
            columnsMappedBuilder.set(sIdx);
        }
        ImmutableBitSet columnsMapped = columnsMappedBuilder.build();
        for (RexNode r : inputInfo.pulledUpPredicates) {
            RexNode r2 = this.projectPredicate(rexBuilder, input, r, columnsMapped);
            if (r2.isAlwaysTrue()) continue;
            r2 = r2.accept(new RexPermuteInputsShuttle((Mappings.TargetMapping)m, input));
            projectPullUpPredicates.add(r2);
        }
        for (Ord<RexNode> expr : Ord.zip(project.getProjects())) {
            if (RexLiteral.isNullLiteral((RexNode)expr.e)) {
                projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, rexBuilder.makeInputRef(project, expr.i)));
                continue;
            }
            if (!RexUtil.isConstant((RexNode)expr.e)) continue;
            ImmutableList<RexInputRef> args = ImmutableList.of(rexBuilder.makeInputRef(project, expr.i), expr.e);
            SqlBinaryOperator op = ((RexNode)args.get(0)).getType().isNullable() || ((RexNode)args.get(1)).getType().isNullable() ? SqlStdOperatorTable.IS_NOT_DISTINCT_FROM : SqlStdOperatorTable.EQUALS;
            projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)op, args));
        }
        return RelOptPredicateList.of(rexBuilder, projectPullUpPredicates);
    }

    private RexNode projectPredicate(RexBuilder rexBuilder, RelNode input, RexNode r, ImmutableBitSet columnsMapped) {
        ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(r);
        if (columnsMapped.contains(rCols)) {
            return r;
        }
        if (columnsMapped.intersects(rCols)) {
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            for (int c : columnsMapped.intersect(rCols)) {
                if (!input.getRowType().getFieldList().get(c).getType().isNullable() || !Strong.isNull(r, ImmutableBitSet.of(c))) continue;
                list.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, rexBuilder.makeInputRef(input, c)));
            }
            if (!list.isEmpty()) {
                return RexUtil.composeDisjunction(rexBuilder, list);
            }
        }
        return rexBuilder.makeLiteral(true);
    }

    public RelOptPredicateList getPredicates(Filter filter, RelMetadataQuery mq) {
        RelNode input = filter.getInput();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelOptPredicateList inputInfo = mq.getPulledUpPredicates(input);
        return Util.first(inputInfo, RelOptPredicateList.EMPTY).union(rexBuilder, RelOptPredicateList.of(rexBuilder, RexUtil.retainDeterministic(RelOptUtil.conjunctions(filter.getCondition()))));
    }

    public RelOptPredicateList getPredicates(SemiJoin semiJoin, RelMetadataQuery mq) {
        RexBuilder rB = semiJoin.getCluster().getRexBuilder();
        RelNode left = semiJoin.getInput(0);
        RelNode right = semiJoin.getInput(1);
        RelOptPredicateList leftInfo = mq.getPulledUpPredicates(left);
        RelOptPredicateList rightInfo = mq.getPulledUpPredicates(right);
        JoinConditionBasedPredicateInference jI = new JoinConditionBasedPredicateInference(semiJoin, RexUtil.composeConjunction(rB, leftInfo.pulledUpPredicates, false), RexUtil.composeConjunction(rB, rightInfo.pulledUpPredicates, false));
        return jI.inferPredicates(false);
    }

    public RelOptPredicateList getPredicates(Join join, RelMetadataQuery mq) {
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode left = join.getInput(0);
        RelNode right = join.getInput(1);
        RelOptPredicateList leftInfo = mq.getPulledUpPredicates(left);
        RelOptPredicateList rightInfo = mq.getPulledUpPredicates(right);
        JoinConditionBasedPredicateInference jI = new JoinConditionBasedPredicateInference(join, RexUtil.composeConjunction(rB, leftInfo.pulledUpPredicates, false), RexUtil.composeConjunction(rB, rightInfo.pulledUpPredicates, false));
        return jI.inferPredicates(false);
    }

    public RelOptPredicateList getPredicates(Aggregate agg, RelMetadataQuery mq) {
        RelNode input = agg.getInput();
        RexBuilder rexBuilder = agg.getCluster().getRexBuilder();
        RelOptPredicateList inputInfo = mq.getPulledUpPredicates(input);
        ArrayList<RexNode> aggPullUpPredicates = new ArrayList<RexNode>();
        ImmutableBitSet groupKeys = agg.getGroupSet();
        if (groupKeys.isEmpty()) {
            return RelOptPredicateList.EMPTY;
        }
        Mapping m = Mappings.create(MappingType.PARTIAL_FUNCTION, input.getRowType().getFieldCount(), agg.getRowType().getFieldCount());
        int i = 0;
        Iterator iterator = groupKeys.iterator();
        while (iterator.hasNext()) {
            int j = iterator.next();
            m.set(j, i++);
        }
        for (RexNode r : inputInfo.pulledUpPredicates) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(r);
            if (!groupKeys.contains(rCols)) continue;
            r = r.accept(new RexPermuteInputsShuttle((Mappings.TargetMapping)m, input));
            aggPullUpPredicates.add(r);
        }
        return RelOptPredicateList.of(rexBuilder, aggPullUpPredicates);
    }

    public RelOptPredicateList getPredicates(Union union, RelMetadataQuery mq) {
        RexBuilder rB = union.getCluster().getRexBuilder();
        HashMap finalPreds = new HashMap();
        ArrayList<RexNode> finalResidualPreds = new ArrayList<RexNode>();
        for (int i = 0; i < union.getInputs().size(); ++i) {
            RelNode input = union.getInputs().get(i);
            RelOptPredicateList info = mq.getPulledUpPredicates(input);
            if (info.pulledUpPredicates.isEmpty()) {
                return RelOptPredicateList.EMPTY;
            }
            HashMap<String, RexNode> preds = new HashMap<String, RexNode>();
            ArrayList<RexNode> residualPreds = new ArrayList<RexNode>();
            for (RexNode pred : info.pulledUpPredicates) {
                String predDigest = pred.toString();
                if (i == 0) {
                    preds.put(predDigest, pred);
                    continue;
                }
                if (finalPreds.containsKey(predDigest)) {
                    preds.put(predDigest, pred);
                    continue;
                }
                residualPreds.add(pred);
            }
            finalResidualPreds.add(RexUtil.composeConjunction(rB, residualPreds, false));
            for (Map.Entry e : finalPreds.entrySet()) {
                if (preds.containsKey(e.getKey())) continue;
                for (int j = 0; j < i; ++j) {
                    finalResidualPreds.set(j, RexUtil.composeConjunction(rB, Lists.newArrayList((RexNode)finalResidualPreds.get(j), (RexNode)e.getValue()), false));
                }
            }
            finalPreds = preds;
        }
        ArrayList<RexNode> preds = new ArrayList<RexNode>(finalPreds.values());
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        RelOptCluster cluster = union.getCluster();
        RexExecutor executor = Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR);
        RexSimplify simplify = new RexSimplify(rB, predicates, true, executor);
        RexNode disjPred = simplify.simplifyOrs(finalResidualPreds);
        if (!disjPred.isAlwaysTrue()) {
            preds.add(disjPred);
        }
        return RelOptPredicateList.of(rB, preds);
    }

    public RelOptPredicateList getPredicates(Sort sort, RelMetadataQuery mq) {
        RelNode input = sort.getInput();
        return mq.getPulledUpPredicates(input);
    }

    public RelOptPredicateList getPredicates(Exchange exchange, RelMetadataQuery mq) {
        RelNode input = exchange.getInput();
        return mq.getPulledUpPredicates(input);
    }

    public RelOptPredicateList getPredicates(RelSubset r, RelMetadataQuery mq) {
        return RelOptPredicateList.EMPTY;
    }

    static class JoinConditionBasedPredicateInference {
        final Join joinRel;
        final boolean isSemiJoin;
        final int nSysFields;
        final int nFieldsLeft;
        final int nFieldsRight;
        final ImmutableBitSet leftFieldsBitSet;
        final ImmutableBitSet rightFieldsBitSet;
        final ImmutableBitSet allFieldsBitSet;
        SortedMap<Integer, BitSet> equivalence;
        final Map<String, ImmutableBitSet> exprFields;
        final Set<String> allExprsDigests;
        final Set<String> equalityPredicates;
        final RexNode leftChildPredicates;
        final RexNode rightChildPredicates;

        JoinConditionBasedPredicateInference(Join joinRel, RexNode lPreds, RexNode rPreds) {
            this(joinRel, joinRel instanceof SemiJoin, lPreds, rPreds);
        }

        private JoinConditionBasedPredicateInference(Join joinRel, boolean isSemiJoin, RexNode lPreds, RexNode rPreds) {
            this.joinRel = joinRel;
            this.isSemiJoin = isSemiJoin;
            this.nFieldsLeft = joinRel.getLeft().getRowType().getFieldList().size();
            this.nFieldsRight = joinRel.getRight().getRowType().getFieldList().size();
            this.nSysFields = joinRel.getSystemFieldList().size();
            this.leftFieldsBitSet = ImmutableBitSet.range(this.nSysFields, this.nSysFields + this.nFieldsLeft);
            this.rightFieldsBitSet = ImmutableBitSet.range(this.nSysFields + this.nFieldsLeft, this.nSysFields + this.nFieldsLeft + this.nFieldsRight);
            this.allFieldsBitSet = ImmutableBitSet.range(0, this.nSysFields + this.nFieldsLeft + this.nFieldsRight);
            this.exprFields = Maps.newHashMap();
            this.allExprsDigests = new HashSet<String>();
            if (lPreds == null) {
                this.leftChildPredicates = null;
            } else {
                Mappings.TargetMapping leftMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft, this.nSysFields, 0, this.nFieldsLeft);
                this.leftChildPredicates = lPreds.accept(new RexPermuteInputsShuttle(leftMapping, joinRel.getInput(0)));
                for (RexNode r : RelOptUtil.conjunctions(this.leftChildPredicates)) {
                    this.exprFields.put(r.toString(), RelOptUtil.InputFinder.bits(r));
                    this.allExprsDigests.add(r.toString());
                }
            }
            if (rPreds == null) {
                this.rightChildPredicates = null;
            } else {
                Mappings.TargetMapping rightMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft + this.nFieldsRight, this.nSysFields + this.nFieldsLeft, 0, this.nFieldsRight);
                this.rightChildPredicates = rPreds.accept(new RexPermuteInputsShuttle(rightMapping, joinRel.getInput(1)));
                for (RexNode r : RelOptUtil.conjunctions(this.rightChildPredicates)) {
                    this.exprFields.put(r.toString(), RelOptUtil.InputFinder.bits(r));
                    this.allExprsDigests.add(r.toString());
                }
            }
            this.equivalence = Maps.newTreeMap();
            this.equalityPredicates = new HashSet<String>();
            for (int i = 0; i < this.nSysFields + this.nFieldsLeft + this.nFieldsRight; ++i) {
                this.equivalence.put(i, BitSets.of(i));
            }
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            List<RexNode> exprs = RelOptUtil.conjunctions(this.compose(rexBuilder, ImmutableList.of(joinRel.getCondition())));
            final EquivalenceFinder eF = new EquivalenceFinder();
            new ArrayList<Void>(Lists.transform(exprs, new Function<RexNode, Void>(){

                @Override
                public Void apply(RexNode input) {
                    return input.accept(eF);
                }
            }));
            this.equivalence = BitSets.closure(this.equivalence);
        }

        public RelOptPredicateList inferPredicates(boolean includeEqualityInference) {
            ArrayList<RexNode> inferredPredicates = new ArrayList<RexNode>();
            HashSet<String> allExprsDigests = new HashSet<String>(this.allExprsDigests);
            JoinRelType joinType = this.joinRel.getJoinType();
            switch (joinType) {
                case INNER: 
                case LEFT: {
                    this.infer(this.leftChildPredicates, allExprsDigests, inferredPredicates, includeEqualityInference, joinType == JoinRelType.LEFT ? this.rightFieldsBitSet : this.allFieldsBitSet);
                }
            }
            switch (joinType) {
                case INNER: 
                case RIGHT: {
                    this.infer(this.rightChildPredicates, allExprsDigests, inferredPredicates, includeEqualityInference, joinType == JoinRelType.RIGHT ? this.leftFieldsBitSet : this.allFieldsBitSet);
                }
            }
            Mappings.TargetMapping rightMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft + this.nFieldsRight, 0, this.nSysFields + this.nFieldsLeft, this.nFieldsRight);
            RexPermuteInputsShuttle rightPermute = new RexPermuteInputsShuttle(rightMapping, this.joinRel);
            Mappings.TargetMapping leftMapping = Mappings.createShiftMapping(this.nSysFields + this.nFieldsLeft, 0, this.nSysFields, this.nFieldsLeft);
            RexPermuteInputsShuttle leftPermute = new RexPermuteInputsShuttle(leftMapping, this.joinRel);
            ArrayList<RexNode> leftInferredPredicates = new ArrayList<RexNode>();
            ArrayList<RexNode> rightInferredPredicates = new ArrayList<RexNode>();
            for (RexNode iP : inferredPredicates) {
                ImmutableBitSet iPBitSet = RelOptUtil.InputFinder.bits(iP);
                if (this.leftFieldsBitSet.contains(iPBitSet)) {
                    leftInferredPredicates.add(iP.accept(leftPermute));
                    continue;
                }
                if (!this.rightFieldsBitSet.contains(iPBitSet)) continue;
                rightInferredPredicates.add(iP.accept(rightPermute));
            }
            RexBuilder rexBuilder = this.joinRel.getCluster().getRexBuilder();
            switch (joinType) {
                case INNER: {
                    Iterable<RexNode> pulledUpPredicates = this.isSemiJoin ? Iterables.concat(RelOptUtil.conjunctions(this.leftChildPredicates), leftInferredPredicates) : Iterables.concat(RelOptUtil.conjunctions(this.leftChildPredicates), RelOptUtil.conjunctions(this.rightChildPredicates), RexUtil.retainDeterministic(RelOptUtil.conjunctions(this.joinRel.getCondition())), inferredPredicates);
                    return RelOptPredicateList.of(rexBuilder, pulledUpPredicates, leftInferredPredicates, rightInferredPredicates);
                }
                case LEFT: {
                    return RelOptPredicateList.of(rexBuilder, RelOptUtil.conjunctions(this.leftChildPredicates), leftInferredPredicates, rightInferredPredicates);
                }
                case RIGHT: {
                    return RelOptPredicateList.of(rexBuilder, RelOptUtil.conjunctions(this.rightChildPredicates), inferredPredicates, EMPTY_LIST);
                }
            }
            assert (inferredPredicates.size() == 0);
            return RelOptPredicateList.EMPTY;
        }

        public RexNode left() {
            return this.leftChildPredicates;
        }

        public RexNode right() {
            return this.rightChildPredicates;
        }

        private void infer(RexNode predicates, Set<String> allExprsDigests, List<RexNode> inferedPredicates, boolean includeEqualityInference, ImmutableBitSet inferringFields) {
            for (RexNode r : RelOptUtil.conjunctions(predicates)) {
                if (!includeEqualityInference && this.equalityPredicates.contains(r.toString())) continue;
                for (Mapping m : this.mappings(r)) {
                    RexNode tr = r.accept(new RexPermuteInputsShuttle((Mappings.TargetMapping)m, this.joinRel.getInput(0), this.joinRel.getInput(1)));
                    if (!inferringFields.contains(RelOptUtil.InputFinder.bits(tr)) || allExprsDigests.contains(tr.toString()) || this.isAlwaysTrue(tr)) continue;
                    inferedPredicates.add(tr);
                    allExprsDigests.add(tr.toString());
                }
            }
        }

        Iterable<Mapping> mappings(final RexNode predicate) {
            return new Iterable<Mapping>(){

                @Override
                public Iterator<Mapping> iterator() {
                    ImmutableBitSet fields = JoinConditionBasedPredicateInference.this.exprFields.get(predicate.toString());
                    if (fields.cardinality() == 0) {
                        return Collections.emptyIterator();
                    }
                    return new ExprsItr(fields);
                }
            };
        }

        private void equivalent(int p1, int p2) {
            BitSet b = (BitSet)this.equivalence.get(p1);
            b.set(p2);
            b = (BitSet)this.equivalence.get(p2);
            b.set(p1);
        }

        RexNode compose(RexBuilder rexBuilder, Iterable<RexNode> exprs) {
            exprs = Linq4j.asEnumerable(exprs).where(new Predicate1<RexNode>(){

                @Override
                public boolean apply(RexNode expr) {
                    return expr != null;
                }
            });
            return RexUtil.composeConjunction(rexBuilder, exprs, false);
        }

        private int pos(RexNode expr) {
            if (expr instanceof RexInputRef) {
                return ((RexInputRef)expr).getIndex();
            }
            return -1;
        }

        private boolean isAlwaysTrue(RexNode predicate) {
            RexCall c;
            if (predicate instanceof RexCall && (c = (RexCall)predicate).getOperator().getKind() == SqlKind.EQUALS) {
                int lPos = this.pos(c.getOperands().get(0));
                int rPos = this.pos(c.getOperands().get(1));
                return lPos != -1 && lPos == rPos;
            }
            return predicate.isAlwaysTrue();
        }

        class ExprsItr
        implements Iterator<Mapping> {
            final int[] columns;
            final BitSet[] columnSets;
            final int[] iterationIdx;
            Mapping nextMapping = null;
            boolean firstCall;

            ExprsItr(ImmutableBitSet fields) {
                this.columns = new int[fields.cardinality()];
                this.columnSets = new BitSet[fields.cardinality()];
                this.iterationIdx = new int[fields.cardinality()];
                int j = 0;
                int i = fields.nextSetBit(0);
                while (i >= 0) {
                    this.columns[j] = i;
                    this.columnSets[j] = (BitSet)JoinConditionBasedPredicateInference.this.equivalence.get(i);
                    this.iterationIdx[j] = 0;
                    i = fields.nextSetBit(i + 1);
                    ++j;
                }
                this.firstCall = true;
            }

            @Override
            public boolean hasNext() {
                if (this.firstCall) {
                    this.initializeMapping();
                    this.firstCall = false;
                } else {
                    this.computeNextMapping(this.iterationIdx.length - 1);
                }
                return this.nextMapping != null;
            }

            @Override
            public Mapping next() {
                return this.nextMapping;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void computeNextMapping(int level) {
                int t = this.columnSets[level].nextSetBit(this.iterationIdx[level]);
                if (t < 0) {
                    if (level == 0) {
                        this.nextMapping = null;
                    } else {
                        int tmp = this.columnSets[level].nextSetBit(0);
                        this.nextMapping.set(this.columns[level], tmp);
                        this.iterationIdx[level] = tmp + 1;
                        this.computeNextMapping(level - 1);
                    }
                } else {
                    this.nextMapping.set(this.columns[level], t);
                    this.iterationIdx[level] = t + 1;
                }
            }

            private void initializeMapping() {
                this.nextMapping = Mappings.create(MappingType.PARTIAL_FUNCTION, JoinConditionBasedPredicateInference.this.nSysFields + JoinConditionBasedPredicateInference.this.nFieldsLeft + JoinConditionBasedPredicateInference.this.nFieldsRight, JoinConditionBasedPredicateInference.this.nSysFields + JoinConditionBasedPredicateInference.this.nFieldsLeft + JoinConditionBasedPredicateInference.this.nFieldsRight);
                for (int i = 0; i < this.columnSets.length; ++i) {
                    BitSet c = this.columnSets[i];
                    int t = c.nextSetBit(this.iterationIdx[i]);
                    if (t < 0) {
                        this.nextMapping = null;
                        return;
                    }
                    this.nextMapping.set(this.columns[i], t);
                    this.iterationIdx[i] = t + 1;
                }
            }
        }

        class EquivalenceFinder
        extends RexVisitorImpl<Void> {
            protected EquivalenceFinder() {
                super(true);
            }

            @Override
            public Void visitCall(RexCall call) {
                if (call.getOperator().getKind() == SqlKind.EQUALS) {
                    int lPos = JoinConditionBasedPredicateInference.this.pos(call.getOperands().get(0));
                    int rPos = JoinConditionBasedPredicateInference.this.pos(call.getOperands().get(1));
                    if (lPos != -1 && rPos != -1) {
                        JoinConditionBasedPredicateInference.this.equivalent(lPos, rPos);
                        JoinConditionBasedPredicateInference.this.equalityPredicates.add(call.toString());
                    }
                }
                return null;
            }
        }
    }
}

