/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;

public class AutoDeleteDirectory
implements Closeable {
    private final File tempFile;

    public AutoDeleteDirectory(File file) {
        try {
            this.tempFile = file;
            this.init();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("create temp file " + file + " failed", e);
        }
    }

    public AutoDeleteDirectory(String prefix, String suffix) {
        try {
            this.tempFile = File.createTempFile(prefix, suffix);
            this.init();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("create temp file " + prefix + "****" + suffix + " failed", e);
        }
    }

    private void init() throws IOException {
        Preconditions.checkNotNull(this.tempFile);
        if (this.tempFile.exists()) {
            FileUtils.forceDelete((File)this.tempFile);
        }
        this.tempFile.mkdirs();
    }

    public String getAbsolutePath() {
        return this.tempFile.getAbsolutePath();
    }

    public AutoDeleteDirectory child(String child) {
        return new AutoDeleteDirectory(new File(this.tempFile, child));
    }

    public File getFile() {
        return this.tempFile;
    }

    @Override
    public void close() throws IOException {
        if (this.tempFile != null && this.tempFile.exists()) {
            FileUtils.forceDelete((File)this.tempFile);
        }
    }
}

