/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JDBCResourceStore;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.job.shaded.org.apache.commons.dbcp.BasicDataSource;
import org.apache.kylin.job.shaded.org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(JDBCConnectionManager.class);
    private static final String PASSWORD = "password";
    private static JDBCConnectionManager INSTANCE = null;
    private final Map<String, String> dbcpProps;
    private final DataSource dataSource;

    public static synchronized JDBCConnectionManager getConnectionManager() {
        if (INSTANCE == null) {
            INSTANCE = new JDBCConnectionManager(KylinConfig.getInstanceFromEnv());
        }
        return INSTANCE;
    }

    private JDBCConnectionManager(KylinConfig config) {
        try {
            this.dbcpProps = this.initDbcpProps(config);
            this.dataSource = BasicDataSourceFactory.createDataSource(this.getDbcpProperties());
            Connection conn = this.getConn();
            DatabaseMetaData mdm = conn.getMetaData();
            logger.info("Connected to {} {}", (Object)mdm.getDatabaseProductName(), (Object)mdm.getDatabaseProductVersion());
            JDBCConnectionManager.closeQuietly(conn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Map<String, String> initDbcpProps(KylinConfig config) {
        StorageURL metadataUrl = config.getMetadataUrl();
        JDBCResourceStore.checkScheme(metadataUrl);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(metadataUrl.getAllParameters());
        List<String> mandatoryItems = Arrays.asList("url", "username", PASSWORD);
        for (String item : mandatoryItems) {
            Preconditions.checkNotNull(ret.get(item), "Setting item \"" + item + "\" is mandatory for Jdbc connections.");
        }
        if ("true".equals(ret.get("passwordEncrypted"))) {
            String password = ret.get(PASSWORD);
            ret.put(PASSWORD, EncryptUtil.decrypt(password));
            ret.remove("passwordEncrypted");
        }
        logger.info("Connecting to Jdbc with url:{} by user {}", (Object)ret.get("url"), (Object)ret.get("username"));
        this.putIfMissing(ret, "driverClassName", "com.mysql.jdbc.Driver");
        this.putIfMissing(ret, "maxActive", "5");
        this.putIfMissing(ret, "maxIdle", "5");
        this.putIfMissing(ret, "maxWait", "1000");
        this.putIfMissing(ret, "removeAbandoned", "true");
        this.putIfMissing(ret, "removeAbandonedTimeout", "180");
        this.putIfMissing(ret, "testOnBorrow", "true");
        this.putIfMissing(ret, "testWhileIdle", "true");
        this.putIfMissing(ret, "validationQuery", "select 1");
        return ret;
    }

    private void putIfMissing(LinkedHashMap<String, String> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    public final Connection getConn() throws SQLException {
        return this.dataSource.getConnection();
    }

    public Properties getDbcpProperties() {
        Properties ret = new Properties();
        ret.putAll(this.dbcpProps);
        return ret;
    }

    public static void closeQuietly(AutoCloseable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (Exception e) {
                logger.warn("Error closing " + obj, e);
            }
        }
    }

    public void close() {
        try {
            ((BasicDataSource)this.dataSource).close();
        }
        catch (SQLException e) {
            logger.error("error closing data source", e);
        }
    }
}

