/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup.cache;

import java.io.IOException;
import java.util.Iterator;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.cache.RocksDBLookupRowEncoder;
import org.apache.kylin.metadata.model.TableDesc;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBLookupTable
implements ILookupTable {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBLookupTable.class);
    private RocksDB rocksDB;
    private Options options = new Options();
    private RocksDBLookupRowEncoder rowEncoder;

    public RocksDBLookupTable(TableDesc tableDesc, String[] keyColumns, String dbPath) {
        this.rowEncoder = new RocksDBLookupRowEncoder(tableDesc, keyColumns);
        try {
            this.rocksDB = RocksDB.openReadOnly(this.options, dbPath);
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("cannot open rocks db in path:" + dbPath, e);
        }
    }

    @Override
    public String[] getRow(Array<String> key) {
        byte[] encodeKey = this.rowEncoder.encodeStringsWithLenPfx(key.getData(), false);
        try {
            byte[] value = this.rocksDB.get(encodeKey);
            if (value == null) {
                return null;
            }
            return this.rowEncoder.decode(new RocksDBLookupRowEncoder.KV(encodeKey, value));
        }
        catch (RocksDBException e) {
            throw new IllegalStateException("error when get key from rocksdb", e);
        }
    }

    @Override
    public Iterator<String[]> iterator() {
        final RocksIterator rocksIterator = this.getRocksIterator();
        rocksIterator.seekToFirst();
        return new Iterator<String[]>(){
            int counter;

            @Override
            public boolean hasNext() {
                boolean valid = rocksIterator.isValid();
                if (!valid) {
                    rocksIterator.close();
                }
                return valid;
            }

            @Override
            public String[] next() {
                ++this.counter;
                if (this.counter % 100000 == 0) {
                    logger.info("scanned {} rows from rocksDB", (Object)this.counter);
                }
                String[] result = RocksDBLookupTable.this.rowEncoder.decode(new RocksDBLookupRowEncoder.KV(rocksIterator.key(), rocksIterator.value()));
                rocksIterator.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not support operation");
            }
        };
    }

    private RocksIterator getRocksIterator() {
        return this.rocksDB.newIterator();
    }

    @Override
    public void close() throws IOException {
        this.options.close();
        if (this.rocksDB != null) {
            this.rocksDB.close();
        }
    }

    static {
        RocksDB.loadLibrary();
    }
}

