/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.io.IOException;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopOutputFormatBase;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.Progress;

public class HadoopMultipleOutputFormat<K, V>
extends HadoopOutputFormatBase<K, V, Tuple2<String, Tuple3<K, V, String>>> {
    private static final long serialVersionUID = 1L;
    protected static final Object OPEN_MULTIPLE_MUTEX = new Object();
    protected static final Object CLOSE_MULTIPLE_MUTEX = new Object();
    protected MultipleOutputs writer;

    public HadoopMultipleOutputFormat(OutputFormat<K, V> mapreduceOutputFormat, Job job) {
        super(mapreduceOutputFormat, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        Object object = OPEN_MULTIPLE_MUTEX;
        synchronized (object) {
            try {
                ReduceContextImpl taskInputOutputContext = new ReduceContextImpl(this.configuration, this.context.getTaskAttemptID(), (RawKeyValueIterator)new InputIterator(), (Counter)new GenericCounter(), (Counter)new GenericCounter(), this.recordWriter, this.outputCommitter, (StatusReporter)new TaskAttemptContextImpl.DummyReporter(), null, BytesWritable.class, BytesWritable.class);
                this.writer = new MultipleOutputs((TaskInputOutputContext)taskInputOutputContext);
            }
            catch (InterruptedException e) {
                throw new IOException("Could not create MultipleOutputs.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        Object object = CLOSE_MULTIPLE_MUTEX;
        synchronized (object) {
            try {
                this.writer.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Could not close MultipleOutputs.", e);
            }
        }
    }

    public void writeRecord(Tuple2<String, Tuple3<K, V, String>> record) throws IOException {
        try {
            this.writer.write((String)record.f0, ((Tuple3)record.f1).f0, ((Tuple3)record.f1).f1, (String)((Tuple3)record.f1).f2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static class InputIterator
    implements RawKeyValueIterator {
        InputIterator() {
        }

        public DataInputBuffer getKey() throws IOException {
            return null;
        }

        public DataInputBuffer getValue() throws IOException {
            return null;
        }

        public Progress getProgress() {
            return null;
        }

        public boolean next() throws IOException {
            return false;
        }

        public void close() throws IOException {
        }
    }
}

