/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.mr.DFSFileTableReader;
import org.apache.kylin.source.IReadableTable;

public class DFSFileTable
implements IReadableTable {
    public static final String DELIM_AUTO = "auto";
    public static final String DELIM_COMMA = ",";
    String path;
    String delim;
    int nColumns;

    public DFSFileTable(String path, int nColumns) {
        this(path, DELIM_AUTO, nColumns);
    }

    public DFSFileTable(String path, String delim, int nColumns) {
        this.path = path;
        this.delim = delim;
        this.nColumns = nColumns;
    }

    public String getColumnDelimeter() {
        return this.delim;
    }

    @Override
    public IReadableTable.TableReader getReader() throws IOException {
        return new DFSFileTableReader(this.path, this.delim, this.nColumns);
    }

    @Override
    public IReadableTable.TableSignature getSignature() throws IOException {
        Pair<Long, Long> sizeAndLastModified;
        try {
            sizeAndLastModified = DFSFileTable.getSizeAndLastModified(this.path);
        }
        catch (FileNotFoundException ex) {
            sizeAndLastModified = Pair.newPair(-1L, 0L);
        }
        return new IReadableTable.TableSignature(this.path, sizeAndLastModified.getFirst(), sizeAndLastModified.getSecond());
    }

    @Override
    public boolean exists() throws IOException {
        try {
            DFSFileTable.getSizeAndLastModified(this.path);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public String toString() {
        return this.path;
    }

    public static Pair<Long, Long> getSizeAndLastModified(String path) throws IOException {
        FileSystem fs = HadoopUtil.getFileSystem(path);
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        FileStatus status = fs.getFileStatus(new Path(path));
        if (status.isFile()) {
            allFiles.add(status);
        } else {
            FileStatus[] listStatus = fs.listStatus(new Path(path));
            allFiles.addAll(Arrays.asList(listStatus));
        }
        long size = 0L;
        long lastModified = 0L;
        for (FileStatus file : allFiles) {
            size += file.getLen();
            lastModified = Math.max(lastModified, file.getModificationTime());
        }
        return Pair.newPair(size, lastModified);
    }
}

