/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateStatsFromBaseCuboidReducer
extends KylinReducer<Text, Text, NullWritable, Text> {
    private static final Logger logger = LoggerFactory.getLogger(CalculateStatsFromBaseCuboidReducer.class);
    private KylinConfig cubeConfig;
    protected long baseCuboidId;
    protected Map<Long, HLLCounter> cuboidHLLMap = null;
    private List<Long> baseCuboidRowCountInMappers;
    private long totalRowsBeforeMerge = 0L;
    private String output = null;
    private int samplingPercentage;
    private int taskId;

    @Override
    protected void doSetup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        Configuration conf = context.getConfiguration();
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        String cubeName = conf.get("cube.name");
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        this.cubeConfig = cube.getConfig();
        this.baseCuboidId = cube.getCuboidScheduler().getBaseCuboidId();
        this.baseCuboidRowCountInMappers = Lists.newLinkedList();
        this.output = conf.get("output.path");
        this.samplingPercentage = Integer.parseInt(context.getConfiguration().get("statistics.sampling.percent"));
        this.taskId = context.getTaskAttemptID().getTaskID().getId();
        this.cuboidHLLMap = Maps.newHashMap();
    }

    @Override
    public void doReduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        long cuboidId = Bytes.toLong(key.getBytes());
        logger.info("Cuboid id to be processed: " + cuboidId);
        for (Text value : values) {
            HLLCounter hll = new HLLCounter(this.cubeConfig.getCubeStatsHLLPrecision());
            ByteBuffer bf = ByteBuffer.wrap(value.getBytes(), 0, value.getLength());
            hll.readRegisters(bf);
            if (cuboidId == this.baseCuboidId) {
                this.baseCuboidRowCountInMappers.add(hll.getCountEstimate());
            }
            this.totalRowsBeforeMerge += hll.getCountEstimate();
            if (this.cuboidHLLMap.get(cuboidId) != null) {
                this.cuboidHLLMap.get(cuboidId).merge(hll);
                continue;
            }
            this.cuboidHLLMap.put(cuboidId, hll);
        }
    }

    @Override
    protected void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
        long grandTotal = 0L;
        for (HLLCounter hll : this.cuboidHLLMap.values()) {
            grandTotal += hll.getCountEstimate();
        }
        double mapperOverlapRatio = grandTotal == 0L ? 0.0 : (double)this.totalRowsBeforeMerge / (double)grandTotal;
        CubeStatsWriter.writePartialCuboidStatistics(context.getConfiguration(), new Path(this.output), this.cuboidHLLMap, this.samplingPercentage, this.baseCuboidRowCountInMappers.size(), mapperOverlapRatio, this.taskId);
    }
}

