/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnarFilesReader {
    private static final Logger logger = LoggerFactory.getLogger(ColumnarFilesReader.class);
    protected Path folderPath;
    protected FileSystem fs;
    protected Path dataFilePath;
    protected Path metaFilePath;

    public ColumnarFilesReader(FileSystem fs, Path folderPath) {
        this.fs = fs;
        this.folderPath = folderPath;
        this.checkPath();
    }

    void checkPath() {
        try {
            RemoteIterator files = this.fs.listFiles(this.folderPath, false);
            if (files == null) {
                throw new IllegalArgumentException("Invalid path " + this.folderPath);
            }
            while (files.hasNext()) {
                LocatedFileStatus fileStatus = (LocatedFileStatus)files.next();
                Path path = fileStatus.getPath();
                String name = path.getName();
                if (name.endsWith(".data")) {
                    this.dataFilePath = path;
                    continue;
                }
                if (name.endsWith(".meta")) {
                    this.metaFilePath = path;
                    continue;
                }
                logger.warn("Contains invalid file {} in path {}", (Object)path, (Object)this.folderPath);
            }
            if (this.dataFilePath == null || this.metaFilePath == null) {
                throw new IllegalArgumentException("Invalid path " + this.folderPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("io error", e);
        }
    }

    public abstract void close() throws IOException;
}

