/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.ArrayContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.BitmapContainerShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.Container;
import org.apache.kylin.job.shaded.org.roaringbitmap.IntConsumer;
import org.apache.kylin.job.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.ReverseBitmapContainerShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.RunContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.ShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.Util;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.MappeableContainer;

public final class BitmapContainer
extends Container
implements Cloneable {
    protected static final int MAX_CAPACITY = 65536;
    private static final long serialVersionUID = 2L;
    private static final int BLOCKSIZE = 128;
    public static final boolean USE_BRANCHLESS = true;
    long[] bitmap;
    int cardinality;
    private final int MAXRUNS = (this.getArraySizeInBytes() - 2) / 4;

    public static ShortIterator getReverseShortIterator(long[] bitmap) {
        return new ReverseBitmapContainerShortIterator(bitmap);
    }

    public static PeekableShortIterator getShortIterator(long[] bitmap) {
        return new BitmapContainerShortIterator(bitmap);
    }

    protected static int serializedSizeInBytes(int unusedCardinality) {
        return 8192;
    }

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = new long[1024];
    }

    public BitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun;
        this.bitmap = new long[1024];
        Util.setBitmapRange(this.bitmap, firstOfRun, lastOfRun);
    }

    private BitmapContainer(int newCardinality, long[] newBitmap) {
        this.cardinality = newCardinality;
        this.bitmap = Arrays.copyOf(newBitmap, newBitmap.length);
    }

    public BitmapContainer(long[] newBitmap, int newCardinality) {
        this.cardinality = newCardinality;
        this.bitmap = newBitmap;
    }

    public BitmapContainer(MappeableBitmapContainer bc) {
        this.cardinality = bc.getCardinality();
        this.bitmap = bc.toLongArray();
    }

    @Override
    public Container add(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.clone();
        Util.setBitmapRange(answer.bitmap, begin, end);
        answer.computeCardinality();
        return answer;
    }

    @Override
    public Container add(short i) {
        long newval;
        int x = Util.toIntUnsigned(i);
        long previous = this.bitmap[x / 64];
        this.bitmap[x / 64] = newval = previous | 1L << x;
        this.cardinality = (int)((long)this.cardinality + ((previous ^ newval) >>> x));
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.length);
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v = value2.content[k];
            if (!this.contains(v)) continue;
            answer.content[answer.cardinality++] = v;
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public int andCardinality(ArrayContainer value2) {
        int answer = 0;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v = value2.content[k];
            if (!this.contains(v)) continue;
            ++answer;
        }
        return answer;
    }

    @Override
    public int andCardinality(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        return newCardinality;
    }

    @Override
    public int andCardinality(RunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = Util.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
            answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container andNot(RunContainer x) {
        BitmapContainer answer = this.clone();
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.resetBitmapRange(answer.bitmap, start, end);
        }
        answer.computeCardinality();
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            Arrays.fill(this.bitmap, 0L);
        }
    }

    @Override
    public BitmapContainer clone() {
        return new BitmapContainer(this.cardinality, this.bitmap);
    }

    protected void computeCardinality() {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            this.cardinality += Long.bitCount(this.bitmap[k]);
        }
    }

    @Override
    public boolean contains(short i) {
        int x = Util.toIntUnsigned(i);
        return (this.bitmap[x / 64] & 1L << x) != 0L;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = Long.reverseBytes(in.readLong());
            this.cardinality += Long.bitCount(w);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BitmapContainer) {
            BitmapContainer srb = (BitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            return Arrays.equals(this.bitmap, srb.bitmap);
        }
        if (o instanceof RunContainer) {
            return o.equals(this);
        }
        return false;
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        int base = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                array[pos++] = (short)(base + Long.bitCount(t - 1L));
            }
            base += 64;
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        int base = mask;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                x[pos++] = base + Long.bitCount(t - 1L);
            }
            base += 64;
        }
    }

    @Override
    public Container flip(short i) {
        int x = Util.toIntUnsigned(i);
        int index = x / 64;
        long bef = this.bitmap[index];
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            int n = index;
            this.bitmap[n] = this.bitmap[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((bef & mask) >>> x)));
        int n = index;
        this.bitmap[n] = this.bitmap[n] ^ mask;
        return this;
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ReverseBitmapContainerShortIterator(this.bitmap);
    }

    @Override
    public PeekableShortIterator getShortIterator() {
        return new BitmapContainerShortIterator(this.bitmap);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.length * 8;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitmap);
    }

    @Override
    public Container iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        Util.setBitmapRange(this.bitmap, begin, end);
        this.computeCardinality();
        return this;
    }

    @Override
    public Container iand(ArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public Container iand(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iand(RunContainer x) {
        int card = x.getCardinality();
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = Util.toIntUnsigned(x.getValue(rlepos));
                int runEnd = runStart + Util.toIntUnsigned(x.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!this.contains((short)runValue)) continue;
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        int start = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int end = Util.toIntUnsigned(x.getValue(rlepos));
            Util.resetBitmapRange(this.bitmap, start, end);
            start = end + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
        }
        Util.resetBitmapRange(this.bitmap, start, Util.maxLowBitAsInteger() + 1);
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content[k]);
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iandNot(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.resetBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected Container ilazyor(ArrayContainer value2) {
        this.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v = value2.content[k];
            int n = i = Util.toIntUnsigned(v) >>> 6;
            this.bitmap[n] = this.bitmap[n] | 1L << v;
        }
        return this;
    }

    protected Container ilazyor(BitmapContainer x) {
        this.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] | x.bitmap[k];
        }
        return this;
    }

    protected Container ilazyor(RunContainer x) {
        this.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(this.bitmap, start, end);
        }
        return this;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        if (lastOfRange - firstOfRange == 65536) {
            Util.flipBitmapRange(this.bitmap, firstOfRange, lastOfRange);
            this.cardinality = 65536 - this.cardinality;
        } else if (lastOfRange - firstOfRange > 32768) {
            Util.flipBitmapRange(this.bitmap, firstOfRange, lastOfRange);
            this.computeCardinality();
        } else {
            this.cardinality += Util.flipBitmapRangeAndCardinalityChange(this.bitmap, firstOfRange, lastOfRange);
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public boolean intersects(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            if (!this.contains(value2.content[k])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitmapContainer value2) {
        for (int k = 0; k < this.bitmap.length; ++k) {
            if ((this.bitmap[k] & value2.bitmap[k]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(RunContainer x) {
        return x.intersects(this);
    }

    @Override
    public BitmapContainer ior(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            int i = Util.toIntUnsigned(value2.content[k]) >>> 6;
            long bef = this.bitmap[i];
            this.bitmap[i] = aft = bef | 1L << value2.content[k];
            this.cardinality = (int)((long)this.cardinality + (bef - aft >>> 63));
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = this.bitmap[k] | b2.bitmap[k];
            this.cardinality += Long.bitCount(w);
        }
        return this;
    }

    @Override
    public Container ior(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        return this;
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        Util.resetBitmapRange(this.bitmap, begin, end);
        this.computeCardinality();
        if (this.getCardinality() <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            final ShortIterator si;
            {
                this.si = BitmapContainer.this.getShortIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Short next() {
                return this.si.next();
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            long mask = 1L << vc;
            int index = Util.toIntUnsigned(vc) >>> 6;
            long ba = this.bitmap[index];
            this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((ba & mask) >>> vc)));
            this.bitmap[index] = ba ^ mask;
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container ixor(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] ^ b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container ixor(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.flipBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected Container lazyor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        answer.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v = value2.content[k];
            int n = i = Util.toIntUnsigned(v) >>> 6;
            answer.bitmap[n] = answer.bitmap[n] | 1L << v;
        }
        return answer;
    }

    protected Container lazyor(BitmapContainer x) {
        BitmapContainer answer = new BitmapContainer();
        answer.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            answer.bitmap[k] = this.bitmap[k] | x.bitmap[k];
        }
        return answer;
    }

    protected Container lazyor(RunContainer x) {
        BitmapContainer bc = this.clone();
        bc.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(bc.bitmap, start, end);
        }
        return bc;
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 4096) {
            ArrayContainer ac = new ArrayContainer(maxcardinality);
            int pos = 0;
            for (int k = 0; ac.cardinality < maxcardinality && k < this.bitmap.length; ++k) {
                long t;
                for (long bitset = this.bitmap[k]; ac.cardinality < maxcardinality && bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    ac.content[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        BitmapContainer bc = new BitmapContainer(maxcardinality, this.bitmap);
        int s = Util.toIntUnsigned(this.select(maxcardinality));
        int usedwords = (s + 63) / 64;
        int todelete = this.bitmap.length - usedwords;
        for (int k = 0; k < todelete; ++k) {
            bc.bitmap[bc.bitmap.length - 1 - k] = 0L;
        }
        int lastword = s % 64;
        if (lastword != 0) {
            bc.bitmap[s / 64] = bc.bitmap[s / 64] << 64 - lastword >> 64 - lastword;
        }
        return bc;
    }

    protected void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        for (int k = 0; k < arrayContainer.cardinality; ++k) {
            short x = arrayContainer.content[k];
            int n = Util.toIntUnsigned(x) / 64;
            this.bitmap[n] = this.bitmap[n] | 1L << x;
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap[x]);
            }
            ++x;
        }
        return -1;
    }

    public short nextUnsetBit(int i) {
        int x = i / 64;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return (short)(i + Long.numberOfTrailingZeros(w));
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != -1L) {
                return (short)(x * 64 + Long.numberOfTrailingZeros(this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            ++x;
        }
        return -1;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        BitmapContainer answer = this.clone();
        return answer.inot(firstOfRange, lastOfRange);
    }

    @Override
    int numberOfRuns() {
        int numRuns = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            numRuns = (int)((long)numRuns + ((long)Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    public int numberOfRunsAdjustment() {
        int ans = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            ans = (int)((long)ans + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL)));
        }
        long word = nextWord;
        if ((word & Long.MIN_VALUE) != 0L) {
            ++ans;
        }
        return ans;
    }

    public int numberOfRunsLowerBound(int mustNotExceed) {
        int numRuns = 0;
        for (int blockOffset = 0; blockOffset < this.bitmap.length; blockOffset += 128) {
            for (int i = blockOffset; i < blockOffset + 128; ++i) {
                long word = this.bitmap[i];
                numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
            }
            if (numRuns <= mustNotExceed) continue;
            return numRuns;
        }
        return numRuns;
    }

    @Override
    public BitmapContainer or(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = Util.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w | 1L << v;
            answer.cardinality = (int)((long)answer.cardinality + (w - aft >>> 63));
        }
        return answer;
    }

    @Override
    public Container or(BitmapContainer value2) {
        BitmapContainer value1 = this.clone();
        return value1.ior(value2);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    public int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(this.bitmap[x]);
            }
            --x;
        }
        return -1;
    }

    @Override
    public int rank(short lowbits) {
        int x = Util.toIntUnsigned(lowbits);
        int leftover = x + 1 & 0x3F;
        int answer = 0;
        for (int k = 0; k < (x + 1) / 64; ++k) {
            answer += Long.bitCount(this.bitmap[k]);
        }
        if (leftover != 0) {
            answer += Long.bitCount(this.bitmap[(x + 1) / 64] << 64 - leftover);
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public Container remove(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.clone();
        Util.resetBitmapRange(answer.bitmap, begin, end);
        answer.computeCardinality();
        if (answer.getCardinality() <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container remove(short i) {
        int x = Util.toIntUnsigned(i);
        int index = x / 64;
        long bef = this.bitmap[index];
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            this.bitmap[x / 64] = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        long aft = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.cardinality = (int)((long)this.cardinality - (aft - bef >>> 63));
        this.bitmap[index] = aft;
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        if (this.getCardinality() < 0) {
            this.computeCardinality();
            if (this.getCardinality() <= 4096) {
                return this.toArrayContainer();
            }
        }
        return this;
    }

    @Override
    public Container runOptimize() {
        int numRuns = this.numberOfRunsLowerBound(this.MAXRUNS);
        int sizeAsRunContainerLowerBound = RunContainer.serializedSizeInBytes(numRuns);
        if (sizeAsRunContainerLowerBound >= this.getArraySizeInBytes()) {
            return this;
        }
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(numRuns += this.numberOfRunsAdjustment());
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public short select(int j) {
        int leftover = j;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int w = Long.bitCount(this.bitmap[k]);
            if (w > leftover) {
                return (short)(k * 64 + Util.select(this.bitmap[k], leftover));
            }
            leftover -= w;
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        for (long w : this.bitmap) {
            out.writeLong(Long.reverseBytes(w));
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return BitmapContainer.serializedSizeInBytes(0);
    }

    public ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        ac.loadData(this);
        if (ac.getCardinality() != this.cardinality) {
            throw new RuntimeException("Internal error.");
        }
        return ac;
    }

    public LongBuffer toLongBuffer() {
        LongBuffer lb = LongBuffer.allocate(this.bitmap.length);
        lb.put(this.bitmap);
        return lb;
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableBitmapContainer(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        PeekableShortIterator i = this.getShortIterator();
        sb.append("{");
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            int index = Util.toIntUnsigned(vc) >>> 6;
            long mask = 1L << vc;
            long val = answer.bitmap[index];
            answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((val & mask) >>> vc)));
            answer.bitmap[index] = val ^ mask;
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container xor(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    @Override
    public void forEach(short msb, IntConsumer ic) {
        int high = msb << 16;
        for (int x = 0; x < this.bitmap.length; ++x) {
            long t;
            for (long w = this.bitmap[x]; w != 0L; w ^= t) {
                t = w & -w;
                ic.accept(x * 64 + Long.bitCount(t - 1L) | high);
            }
        }
    }
}

