/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class DoubleDeltaSerializer
implements Serializable {
    static final int PRECISION_BITS = 3;
    static final int DELTA_SIZE_BITS = 6;
    static final int LENGTH_BITS = 23;
    static final long[] MASKS = new long[64];
    private final int precision;
    private final int multiplier;
    transient ThreadLocal<long[]> deltasThreadLocal;

    public DoubleDeltaSerializer() {
        this(2);
    }

    public DoubleDeltaSerializer(int precision) {
        this.checkFitInBits(precision, 3);
        this.precision = precision;
        this.multiplier = (int)Math.pow(10.0, precision);
    }

    public void serialize(double[] values, ByteBuffer buf) {
        long[] deltas = this.calculateDeltas(values);
        int deltaSize = this.maxDeltaSize(deltas, values.length - 1);
        this.checkFitInBits(deltaSize, 6);
        this.checkFitInBits(values.length, 23);
        int meta = this.precision << 29 | deltaSize << 23 | values.length;
        buf.putInt(meta);
        if (values.length == 0) {
            return;
        }
        buf.putLong(this.roundAndPromote(values[0]));
        this.putDeltas(deltas, values.length - 1, deltaSize, buf);
    }

    private void putDeltas(long[] deltas, int len, int deltaSize, ByteBuffer buf) {
        long bits = 0L;
        int free = 64;
        for (int i = 0; i < len; ++i) {
            if (free >= deltaSize) {
                bits |= deltas[i] << free - deltaSize;
                if ((free -= deltaSize) != 0) continue;
                buf.putLong(bits);
                bits = 0L;
                free = 64;
                continue;
            }
            buf.putLong(bits |= deltas[i] >> deltaSize - free);
            free = 64 - (deltaSize - free);
            bits = deltas[i] << free;
        }
        if (free < 64) {
            buf.putLong(bits);
        }
    }

    private int maxDeltaSize(long[] deltas, int len) {
        long maxDelta = 0L;
        for (int i = 0; i < len; ++i) {
            maxDelta = Math.max(maxDelta, deltas[i]);
        }
        return 64 - Long.numberOfLeadingZeros(maxDelta);
    }

    private long[] calculateDeltas(double[] values) {
        long[] deltas;
        int len = values.length - 1;
        len = Math.max(0, len);
        if (this.deltasThreadLocal == null) {
            this.deltasThreadLocal = new ThreadLocal();
        }
        if ((deltas = this.deltasThreadLocal.get()) == null || deltas.length < len) {
            deltas = new long[len];
            this.deltasThreadLocal.set(deltas);
        }
        if (len == 0) {
            return deltas;
        }
        long current = this.roundAndPromote(values[0]);
        for (int i = 0; i < len; ++i) {
            long next = this.roundAndPromote(values[i + 1]);
            deltas[i] = next - current;
            assert (deltas[i] >= 0L);
            current = next;
        }
        return deltas;
    }

    private long roundAndPromote(double value) {
        return (long)(value * (double)this.multiplier + 0.5);
    }

    private void checkFitInBits(int num, int bits) {
        if (num >= 1 << bits) {
            throw new IllegalArgumentException();
        }
    }

    public double[] deserialize(ByteBuffer buf) {
        int meta = buf.getInt();
        int len = meta & 0x7FFFFF;
        double[] result = new double[len];
        this.deserialize(buf, meta, result);
        return result;
    }

    public int deserialize(ByteBuffer buf, double[] result) {
        return this.deserialize(buf, buf.getInt(), result);
    }

    private int deserialize(ByteBuffer buf, int meta, double[] result) {
        int precision = meta >>> 29;
        assert (precision == this.precision);
        int deltaSize = meta >>> 23 & 0x3F;
        int len = meta & 0x7FFFFF;
        if (len == 0) {
            return 0;
        }
        assert (result.length >= len);
        long current = buf.getLong();
        result[0] = (double)current / (double)this.multiplier;
        long bits = 0L;
        int left = 0;
        for (int i = 1; i < len; ++i) {
            long delta = 0L;
            if (left >= deltaSize) {
                delta = bits >> left - deltaSize & MASKS[deltaSize];
                left -= deltaSize;
            } else {
                int more = deltaSize - left;
                delta = (bits & MASKS[left]) << more;
                bits = buf.getLong();
                left = 64;
                delta |= bits >> left - more & MASKS[more];
                left -= more;
            }
            result[i] = (double)(current += delta) / (double)this.multiplier;
        }
        return len;
    }

    static {
        for (int i = 0; i < MASKS.length; ++i) {
            DoubleDeltaSerializer.MASKS[i] = (1L << i) - 1L;
        }
    }
}

