/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.util.IdentityHashMap;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class TsConditionEraser
implements TupleFilterSerializer.Decorator {
    private final TblColRef tsColumn;
    private final TupleFilter root;
    private IdentityHashMap<TupleFilter, Boolean> isInTopLevelANDs;

    public TsConditionEraser(TblColRef tsColumn, TupleFilter root) {
        this.tsColumn = tsColumn;
        this.root = root;
        this.isInTopLevelANDs = Maps.newIdentityHashMap();
    }

    @Override
    public TupleFilter onSerialize(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        if (this.root == filter) {
            this.isInTopLevelANDs.put(filter, true);
        }
        if (this.isInTopLevelANDs.containsKey(filter)) {
            TblColRef c;
            this.classifyChildrenByMarking(filter);
            if (filter instanceof CompareTupleFilter && (c = ((CompareTupleFilter)filter).getColumn()) != null && c.equals(this.tsColumn)) {
                return null;
            }
        }
        return filter;
    }

    private void classifyChildrenByMarking(TupleFilter filter) {
        if (filter instanceof LogicalTupleFilter && filter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            for (TupleFilter tupleFilter : filter.getChildren()) {
                this.isInTopLevelANDs.put(tupleFilter, true);
            }
        }
    }
}

