/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.TwoLayerFunctionDesc;

public class StdDevSumFunctionDesc
extends TwoLayerFunctionDesc {
    protected TblColRef groupByDim;
    protected TblColRef mCol;
    protected Set<TblColRef> runtimeDims;
    protected Map<TblColRef, FunctionDesc> runtimeFuncMap;

    public StdDevSumFunctionDesc(ParameterDesc parameter, List<TblColRef> allCols) {
        super(parameter, "STDDEV_SUM", "stddev_sum");
        assert (allCols.size() == 2);
        this.groupByDim = allCols.get(0);
        this.runtimeDims = Sets.newHashSet(this.groupByDim);
        this.mCol = allCols.get(1);
        this.runtimeFuncMap = Maps.newHashMap();
        this.runtimeFuncMap.put(this.mCol, this.constructRuntimeFunction(this.mCol));
    }

    @Override
    public String getRewriteFieldName() {
        return "_KY_SUM_" + StdDevSumFunctionDesc.getDigest(this.groupByDim, this.mCol);
    }

    @Override
    public DataType getRewriteFieldType() {
        return DataType.ANY;
    }

    @Override
    public Set<TblColRef> getRuntimeDimensions() {
        return this.runtimeDims;
    }

    @Override
    public Map<TblColRef, FunctionDesc> getRuntimeFuncMap() {
        return this.runtimeFuncMap;
    }

    @Override
    public void setRuntimeFuncMap(Map<TblColRef, FunctionDesc> funcMap) {
        assert (funcMap.size() == 1);
        this.runtimeFuncMap = funcMap;
        this.mCol = funcMap.keySet().iterator().next();
    }

    @Override
    protected FunctionDesc constructRuntimeFunction(TblColRef column) {
        return FunctionDesc.newInstance("SUM", ParameterDesc.newInstance(column), null);
    }

    public static String getDigest(TblColRef dim, TblColRef measure) {
        return "GROUP_BY_" + dim.getIdentity() + "_SUM_(" + measure.getIdentity() + ")";
    }
}

