/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class CalciteParser {
    public static SqlNode parse(String sql) throws SqlParseException {
        SqlParser.ConfigBuilder parserBuilder = SqlParser.configBuilder();
        SqlParser sqlParser = SqlParser.create(sql, parserBuilder.build());
        return sqlParser.parseQuery();
    }

    public static SqlNode getOnlySelectNode(String sql) {
        SqlNodeList selectList = null;
        try {
            selectList = ((SqlSelect)CalciteParser.parse(sql)).getSelectList();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("Failed to parse expression '" + sql + "', please make sure the expression is valid", e);
        }
        Preconditions.checkArgument(selectList.size() == 1, "Expression is invalid because size of select list exceeds one");
        return selectList.get(0);
    }

    public static SqlNode getExpNode(String expr) {
        return CalciteParser.getOnlySelectNode("select " + expr + " from t");
    }

    public static String getLastNthName(SqlIdentifier id, int n) {
        return ((String)id.names.get(id.names.size() - n)).replace("\"", "").toUpperCase(Locale.ROOT);
    }

    public static void ensureNoAliasInExpr(String expr) {
        SqlNode sqlNode = CalciteParser.getExpNode(expr);
        SqlBasicVisitor sqlVisitor = new SqlBasicVisitor(){

            @Override
            public Object visit(SqlIdentifier id) {
                if (id.names.size() > 1) {
                    throw new IllegalArgumentException("Column Identifier in the computed column expression should only contain COLUMN");
                }
                return null;
            }
        };
        sqlNode.accept(sqlVisitor);
    }

    public static String insertAliasInExpr(String expr, String alias) {
        String prefix = "select ";
        String suffix = " from t";
        String sql = prefix + expr + suffix;
        SqlNode sqlNode = CalciteParser.getOnlySelectNode(sql);
        final HashSet s = Sets.newHashSet();
        SqlBasicVisitor sqlVisitor = new SqlBasicVisitor(){

            @Override
            public Object visit(SqlIdentifier id) {
                if (id.names.size() > 1) {
                    throw new IllegalArgumentException("SqlIdentifier " + id + " contains DB/Table name");
                }
                s.add(id);
                return null;
            }
        };
        sqlNode.accept(sqlVisitor);
        ArrayList<SqlIdentifier> sqlIdentifiers = Lists.newArrayList(s);
        CalciteParser.descSortByPosition(sqlIdentifiers);
        for (SqlIdentifier sqlIdentifier : sqlIdentifiers) {
            Pair<Integer, Integer> replacePos = CalciteParser.getReplacePos(sqlIdentifier, sql);
            int start = replacePos.getFirst();
            sql = sql.substring(0, start) + alias + "." + sql.substring(start);
        }
        return sql.substring(prefix.length(), sql.length() - suffix.length());
    }

    public static void descSortByPosition(List<SqlIdentifier> sqlIdentifiers) {
        Collections.sort(sqlIdentifiers, new Comparator<SqlIdentifier>(){

            @Override
            public int compare(SqlIdentifier o1, SqlIdentifier o2) {
                int linegap = o2.getParserPosition().getLineNum() - o1.getParserPosition().getLineNum();
                if (linegap != 0) {
                    return linegap;
                }
                return o2.getParserPosition().getColumnNum() - o1.getParserPosition().getColumnNum();
            }
        });
    }

    public static Pair<Integer, Integer> getReplacePos(SqlNode node, String inputSql) {
        int i;
        if (inputSql == null) {
            return Pair.newPair(0, 0);
        }
        String[] lines = inputSql.split("\n");
        SqlParserPos pos = node.getParserPosition();
        int lineStart = pos.getLineNum();
        int lineEnd = pos.getEndLineNum();
        int columnStart = pos.getColumnNum() - 1;
        int columnEnd = pos.getEndColumnNum();
        for (i = 0; i < lineStart - 1; ++i) {
            columnStart += lines[i].length() + 1;
        }
        for (i = 0; i < lineEnd - 1; ++i) {
            columnEnd += lines[i].length() + 1;
        }
        Pair<Integer, Integer> startEndPos = CalciteParser.getPosWithBracketsCompletion(inputSql, columnStart, columnEnd);
        return startEndPos;
    }

    private static Pair<Integer, Integer> getPosWithBracketsCompletion(String inputSql, int left, int right) {
        int leftBracketNum = 0;
        int rightBracketNum = 0;
        boolean constantFlag = false;
        String substring = inputSql.substring(left, right);
        for (int i = 0; i < substring.length(); ++i) {
            char temp = substring.charAt(i);
            if (temp == '\'') {
                boolean bl = constantFlag = !constantFlag;
            }
            if (constantFlag) continue;
            if (temp == '(') {
                ++leftBracketNum;
            }
            if (temp != ')' || leftBracketNum >= ++rightBracketNum) continue;
            while ('(' != inputSql.charAt(left - 1)) {
                --left;
            }
            --left;
            ++leftBracketNum;
        }
        while (rightBracketNum < leftBracketNum) {
            while (')' != inputSql.charAt(right)) {
                ++right;
            }
            ++right;
            ++rightBracketNum;
        }
        return Pair.newPair(left, right);
    }

    public static String replaceAliasInExpr(String expr, Map<String, String> renaming) {
        String prefix = "select ";
        String suffix = " from t";
        String sql = prefix + expr + suffix;
        SqlNode sqlNode = CalciteParser.getOnlySelectNode(sql);
        final HashSet s = Sets.newHashSet();
        SqlBasicVisitor sqlVisitor = new SqlBasicVisitor(){

            @Override
            public Object visit(SqlIdentifier id) {
                Preconditions.checkState(id.names.size() == 2);
                s.add(id);
                return null;
            }
        };
        sqlNode.accept(sqlVisitor);
        ArrayList<SqlIdentifier> sqlIdentifiers = Lists.newArrayList(s);
        CalciteParser.descSortByPosition(sqlIdentifiers);
        for (SqlIdentifier sqlIdentifier : sqlIdentifiers) {
            Pair<Integer, Integer> replacePos = CalciteParser.getReplacePos(sqlIdentifier, sql);
            int start = replacePos.getFirst();
            int end = replacePos.getSecond();
            String aliasInExpr = (String)sqlIdentifier.names.get(0);
            String col = (String)sqlIdentifier.names.get(1);
            String renamedAlias = renaming.get(aliasInExpr);
            Preconditions.checkNotNull(renamedAlias, "rename for alias " + aliasInExpr + " in expr (" + expr + ") is not found");
            sql = sql.substring(0, start) + renamedAlias + "." + col + sql.substring(end);
        }
        return sql.substring(prefix.length(), sql.length() - suffix.length());
    }
}

