/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOverOperator;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.sdk.datasource.framework.conv.ConvMaster;
import org.apache.kylin.sdk.datasource.framework.conv.ParamNodeParser;
import org.apache.kylin.sdk.datasource.framework.conv.SqlParamsFinder;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;

public class SqlNodeConverter
extends SqlShuttle {
    private final ConvMaster convMaster;

    SqlNodeConverter(ConvMaster convMaster) {
        this.convMaster = convMaster;
    }

    @Override
    public SqlNode visit(SqlDataTypeSpec type) {
        SqlDataTypeSpec target = this.convertSqlDataTypeSpec(type);
        return target == null ? super.visit(type) : target;
    }

    @Override
    public SqlNode visit(SqlCall call) {
        SqlNode target = this.convertSqlCall(call);
        return target == null ? super.visit(call) : target;
    }

    @Override
    public SqlNode visit(SqlIdentifier id) {
        SqlNode target = this.convertSqlIdentifier(id);
        return target == null ? super.visit(id) : target;
    }

    private SqlDataTypeSpec convertSqlDataTypeSpec(SqlDataTypeSpec typeSpec) {
        return this.convMaster.findTargetSqlDataTypeSpec(typeSpec);
    }

    private SqlNode convertSqlIdentifier(SqlIdentifier sqlIdentifier) {
        Pair<SqlNode, SqlNode> matched = this.convMaster.matchSqlFunc(sqlIdentifier);
        if (matched != null) {
            Preconditions.checkState(matched.getFirst() instanceof SqlIdentifier);
            return matched.getSecond();
        }
        return null;
    }

    private SqlNode convertSqlCall(SqlCall sqlCall) {
        Pair<SqlNode, SqlNode> matched;
        SqlOperator operator = sqlCall.getOperator();
        if (operator != null && (matched = this.convMaster.matchSqlFunc(sqlCall)) != null) {
            Preconditions.checkState(matched.getFirst() instanceof SqlCall);
            SqlCall sourceTmpl = (SqlCall)matched.getFirst();
            Preconditions.checkState(sourceTmpl.operandCount() == sqlCall.operandCount());
            SqlNode targetTmpl = matched.getSecond();
            boolean isWindowCall = sourceTmpl.getOperator() instanceof SqlOverOperator;
            SqlParamsFinder sqlParamsFinder = SqlParamsFinder.newInstance(sourceTmpl, sqlCall, isWindowCall);
            return targetTmpl.accept(new SqlFuncFiller(sqlParamsFinder.getParamNodes(), isWindowCall));
        }
        return null;
    }

    private class SqlFuncFiller
    extends SqlShuttle {
        private final Map<Integer, SqlNode> operands;
        private boolean isWindowCall = false;

        private SqlFuncFiller(Map<Integer, SqlNode> operands) {
            this.operands = operands;
        }

        private SqlFuncFiller(Map<Integer, SqlNode> operands, boolean isWindowCall) {
            this.operands = operands;
            this.isWindowCall = isWindowCall;
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            String maybeParam = id.toString();
            int idx = ParamNodeParser.parseParamIdx(maybeParam);
            if (idx >= 0 && this.operands.containsKey(idx)) {
                SqlNode sqlNode = this.operands.get(idx);
                if (sqlNode instanceof SqlIdentifier) {
                    return sqlNode;
                }
                return sqlNode.accept(SqlNodeConverter.this);
            }
            return id;
        }

        @Override
        public SqlNode visit(SqlCall sqlCall) {
            return sqlCall instanceof SqlWindow && this.isWindowCall ? this.operands.get(1) : super.visit(sqlCall);
        }
    }
}

