/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.metadata;

import org.apache.kylin.common.SourceDialect;
import org.apache.kylin.source.hive.DBConnConf;
import org.apache.kylin.source.jdbc.metadata.DefaultJdbcMetadata;
import org.apache.kylin.source.jdbc.metadata.IJdbcMetadata;
import org.apache.kylin.source.jdbc.metadata.MySQLJdbcMetadata;
import org.apache.kylin.source.jdbc.metadata.PostgresqlJdbcMetadata;
import org.apache.kylin.source.jdbc.metadata.SQLServerJdbcMetadata;

public class JdbcMetadataFactory {
    private JdbcMetadataFactory() {
    }

    public static IJdbcMetadata getJdbcMetadata(SourceDialect jdbcDialect, DBConnConf dbConnConf) {
        switch (jdbcDialect) {
            case MSSQL: {
                return new SQLServerJdbcMetadata(dbConnConf);
            }
            case MYSQL: {
                return new MySQLJdbcMetadata(dbConnConf);
            }
            case POSTGRESQL: {
                return new PostgresqlJdbcMetadata(dbConnConf);
            }
        }
        return new DefaultJdbcMetadata(dbConnConf);
    }
}

