/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.lookup.KVSortReducerWithDupKeyCheck;
import org.apache.kylin.storage.hbase.lookup.LookupTableToHFileMapper;
import org.apache.kylin.storage.hbase.steps.CubeHTableUtil;
import org.apache.kylin.storage.hbase.steps.HFileOutputFormat3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTableToHFileJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(LookupTableToHFileJob.class);
    private static String ALPHA_NUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random ran = new Random();
    private static int HBASE_TABLE_LENGTH = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_TABLE_NAME);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_LOOKUP_SNAPSHOT_ID);
            this.parseOptions(options, args);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String tableName = this.getOptionValue(OPTION_TABLE_NAME);
            String lookupSnapshotID = this.getOptionValue(OPTION_LOOKUP_SNAPSHOT_ID);
            String jobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            CubeManager cubeMgr = CubeManager.getInstance(kylinConfig);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            TableDesc tableDesc = TableMetadataManager.getInstance(kylinConfig).getTableDesc(tableName, cube.getProject());
            ExtTableSnapshotInfoManager extSnapshotInfoManager = ExtTableSnapshotInfoManager.getInstance(kylinConfig);
            this.removeSnapshotIfExist(extSnapshotInfoManager, kylinConfig, tableName, lookupSnapshotID);
            IReadableTable sourceTable = SourceManager.createReadableTable(tableDesc, jobId);
            logger.info("create HTable for source table snapshot:{}", (Object)tableName);
            Pair<String, Integer> hTableNameAndShard = this.createHTable(tableName, sourceTable, kylinConfig);
            String[] keyColumns = this.getLookupKeyColumns(cube, tableName);
            ExtTableSnapshotInfo snapshot = this.createSnapshotResource(extSnapshotInfoManager, tableName, lookupSnapshotID, keyColumns, hTableNameAndShard.getFirst(), hTableNameAndShard.getSecond(), sourceTable);
            logger.info("created snapshot information at:{}", (Object)snapshot.getResourcePath());
            this.job = Job.getInstance((Configuration)HBaseConfiguration.create((Configuration)this.getConf()), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.setJobClasspath(this.job, cube.getConfig());
            HBaseConnection.addHBaseClusterNNHAConfiguration(this.job.getConfiguration());
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            IMRInput.IMRTableInputFormat tableInputFormat = MRUtil.getTableInputFormat(tableDesc, jobId);
            tableInputFormat.configureJob(this.job);
            this.job.setMapperClass(LookupTableToHFileMapper.class);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("table.name", tableName);
            this.job.getConfiguration().set("dfs.replication", "3");
            this.job.getConfiguration().set("shard.num", String.valueOf(hTableNameAndShard.getSecond()));
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            Connection conn = this.getHBaseConnection(kylinConfig);
            HTable htable = (HTable)conn.getTable(TableName.valueOf((String)hTableNameAndShard.getFirst()));
            HFileOutputFormat3.configureIncrementalLoad(this.job, (Table)htable, htable.getRegionLocator());
            this.job.setReducerClass(KVSortReducerWithDupKeyCheck.class);
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void removeSnapshotIfExist(ExtTableSnapshotInfoManager extSnapshotInfoManager, KylinConfig kylinConfig, String tableName, String lookupSnapshotID) throws IOException {
        ExtTableSnapshotInfo snapshotInfo = null;
        try {
            snapshotInfo = extSnapshotInfoManager.getSnapshot(tableName, lookupSnapshotID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (snapshotInfo == null) {
            return;
        }
        logger.info("the table:{} snapshot:{} exist, remove it", (Object)tableName, (Object)lookupSnapshotID);
        extSnapshotInfoManager.removeSnapshot(tableName, lookupSnapshotID);
        String hTableName = snapshotInfo.getStorageLocationIdentifier();
        logger.info("remove related HBase table:{} for snapshot:{}", (Object)hTableName, (Object)lookupSnapshotID);
        HBaseConnection.deleteTable(kylinConfig.getStorageUrl(), hTableName);
    }

    private String[] getLookupKeyColumns(CubeInstance cube, String tableName) {
        CubeDesc cubeDesc = cube.getDescriptor();
        DataModelDesc modelDesc = cubeDesc.getModel();
        TableRef lookupTableRef = null;
        for (TableRef tableRef : modelDesc.getLookupTables()) {
            if (!tableRef.getTableIdentity().equalsIgnoreCase(tableName)) continue;
            lookupTableRef = tableRef;
            break;
        }
        if (lookupTableRef == null) {
            throw new IllegalStateException("cannot find table in model:" + tableName);
        }
        JoinDesc joinDesc = modelDesc.getJoinByPKSide(lookupTableRef);
        TblColRef[] keyColRefs = joinDesc.getPrimaryKeyColumns();
        String[] result = new String[keyColRefs.length];
        for (int i = 0; i < keyColRefs.length; ++i) {
            result[i] = keyColRefs[i].getName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, Integer> createHTable(String sourceTableName, IReadableTable sourceTable, KylinConfig kylinConfig) throws IOException {
        IReadableTable.TableSignature signature = sourceTable.getSignature();
        int shardNum = this.calculateShardNum(kylinConfig, signature.getSize());
        Connection conn = this.getHBaseConnection(kylinConfig);
        Admin admin = conn.getAdmin();
        String hTableName = this.genHTableName(kylinConfig, admin, sourceTableName);
        TableName tableName = TableName.valueOf((String)hTableName);
        HTableDescriptor hTableDesc = new HTableDescriptor(tableName);
        hTableDesc.setCompactionEnabled(false);
        hTableDesc.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
        hTableDesc.setValue("KYLIN_HOST", kylinConfig.getMetadataUrlPrefix());
        hTableDesc.setValue("CREATION_TIME", String.valueOf(System.currentTimeMillis()));
        String commitInfo = KylinVersion.getGitCommitInfo();
        if (!StringUtils.isEmpty((String)commitInfo)) {
            hTableDesc.setValue("GIT_COMMIT", commitInfo);
        }
        HColumnDescriptor cf = CubeHTableUtil.createColumnFamily(kylinConfig, "F", false);
        hTableDesc.addFamily(cf);
        try {
            if (shardNum > 1) {
                admin.createTable(hTableDesc, this.getSplitsByShardNum(shardNum));
            } else {
                admin.createTable(hTableDesc);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
        return new Pair<String, Integer>(hTableName, shardNum);
    }

    private int calculateShardNum(KylinConfig kylinConfig, long dataSize) {
        long shardSize = (long)kylinConfig.getExtTableSnapshotShardingMB() * 1024L * 1024L;
        return dataSize < shardSize ? 1 : (int)Math.ceil((double)dataSize / (double)shardSize);
    }

    private byte[][] getSplitsByShardNum(int shardNum) {
        byte[][] result = new byte[shardNum - 1][];
        for (int i = 1; i < shardNum; ++i) {
            byte[] split = new byte[2];
            BytesUtil.writeUnsigned(i, split, 0, 2);
            result[i - 1] = split;
        }
        return result;
    }

    private ExtTableSnapshotInfo createSnapshotResource(ExtTableSnapshotInfoManager extSnapshotInfoManager, String tableName, String snapshotID, String[] keyColumns, String hTableName, int shardNum, IReadableTable sourceTable) throws IOException {
        return extSnapshotInfoManager.createSnapshot(sourceTable.getSignature(), tableName, snapshotID, keyColumns, shardNum, "hbase", hTableName);
    }

    private String genHTableName(KylinConfig kylinConfig, Admin admin, String tableName) throws IOException {
        StringBuilder sb;
        String hTableName;
        String namePrefix = kylinConfig.getHBaseTableNamePrefix() + "LOOKUP_" + tableName + "_";
        String namespace = kylinConfig.getHBaseStorageNameSpace();
        do {
            sb = new StringBuilder();
            if (!(namespace.equals("default") || namespace.equals(""))) {
                sb.append(namespace).append(":");
            }
            sb.append(namePrefix);
            for (int i = 0; i < HBASE_TABLE_LENGTH; ++i) {
                sb.append(ALPHA_NUM.charAt(ran.nextInt(ALPHA_NUM.length())));
            }
        } while (this.hTableExists(admin, hTableName = sb.toString()));
        return hTableName;
    }

    private boolean hTableExists(Admin admin, String hTableName) throws IOException {
        return admin.tableExists(TableName.valueOf((String)hTableName));
    }

    private Connection getHBaseConnection(KylinConfig kylinConfig) throws IOException {
        return HBaseConnection.get(kylinConfig.getStorageUrl());
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new LookupTableToHFileJob(), (String[])args);
        System.exit(exitCode);
    }
}

