/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseUnionUtil {
    private static final Logger logger = LoggerFactory.getLogger(HBaseUnionUtil.class);

    public static Connection getConnection(KylinConfig config, String identifier) throws IOException {
        Connection masterConn = HBaseConnection.get(config.getStorageUrl());
        if (config.getSecondaryStorageUrl() == null) {
            return masterConn;
        }
        if (masterConn.getAdmin().isTableAvailable(TableName.valueOf((String)identifier))) {
            return masterConn;
        }
        logger.info("Table is not found in master cluster: " + config.getStorageUrl() + ", fallback to " + config.getSecondaryStorageUrl());
        return HBaseConnection.get(config.getSecondaryStorageUrl());
    }
}

