/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.io.Files;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimDictionaryMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class FragmentData {
    private static Logger logger = LoggerFactory.getLogger(FragmentData.class);
    private ByteBuffer dataBuffer;
    private FragmentMetaInfo fragmentMetaInfo;
    private File fragmentDataFile;
    private ConcurrentMap<TblColRef, Dictionary<String>> dictionaryMap = Maps.newConcurrentMap();

    public FragmentData(FragmentMetaInfo fragmentMetaInfo, File fragmentDataFile) throws IOException {
        this.fragmentMetaInfo = fragmentMetaInfo;
        this.fragmentDataFile = fragmentDataFile;
        this.dataBuffer = Files.map(fragmentDataFile, FileChannel.MapMode.READ_ONLY);
    }

    public Map<TblColRef, Dictionary<String>> getDimensionDictionaries(TblColRef[] dimensions) {
        HashMap<TblColRef, Dictionary<String>> result = Maps.newHashMap();
        ByteBuffer dictBuffer = this.dataBuffer.asReadOnlyBuffer();
        for (TblColRef dimension : dimensions) {
            Dictionary<?> dict = (Dictionary<?>)this.dictionaryMap.get(dimension);
            if (dict == null) {
                for (DimDictionaryMetaInfo dimDictMetaInfo : this.fragmentMetaInfo.getDimDictionaryMetaInfos()) {
                    if (!dimDictMetaInfo.getDimName().equals(dimension.getName())) continue;
                    int dictLength = dimDictMetaInfo.getDictLength();
                    dictBuffer.position(dimDictMetaInfo.getStartOffset());
                    byte[] dictBytes = new byte[dictLength];
                    dictBuffer.get(dictBytes, 0, dictLength);
                    dict = DictionarySerializer.deserialize(new ByteArray(dictBytes));
                    this.dictionaryMap.put(dimension, dict);
                    break;
                }
            }
            result.put(dimension, (Dictionary<String>)dict);
        }
        return result;
    }

    public int getBufferCapacity() {
        return this.dataBuffer.capacity();
    }

    public ByteBuffer getDataReadBuffer() {
        return this.dataBuffer.asReadOnlyBuffer();
    }

    public FragmentMetaInfo getFragmentMetaInfo() {
        return this.fragmentMetaInfo;
    }

    public int getSize() {
        return this.dataBuffer.capacity();
    }

    public void tryForceUnMapBuffer() {
        if (this.dataBuffer instanceof DirectBuffer) {
            try {
                Cleaner cleaner = ((DirectBuffer)((Object)this.dataBuffer)).cleaner();
                if (cleaner != null) {
                    cleaner.clean();
                    logger.debug("directBuffer cleaned for fragment data:" + this.fragmentDataFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.error("error when clean the fragment data:" + this.fragmentDataFile.getAbsolutePath());
            }
        }
    }
}

